/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client.progression;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cas_ual_ty.spells.client.progression.SpellTreeTab;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.base.SpellIcon;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.util.ProgressionHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class SpellNodeWidget
extends GuiComponent {
    public static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("textures/gui/advancements/widgets.png");
    public static final int[] TEXT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    public static final int BAR_WIDTH = 200;
    public static final int BAR_HEIGHT = 26;
    public static final int TITLE_PADDING_LEFT = 3;
    public static final int TITLE_PADDING_RIGHT = 5;
    public static final int TITLE_X = 32;
    public static final int TITLE_Y = 9;
    public static final int SPELL_WIDTH = 18;
    public static final int SPELL_HEIGHT = 18;
    public static final int FRAME_WIDTH = 26;
    public static final int FRAME_HEIGHT = 26;
    public static final int FRAME_OFF_X = 7;
    public static final int FRAME_OFF_Y = 4;
    public static final int TITLE_MAX_WIDTH = 163;
    public final SpellTreeTab tab;
    public final SpellNode spell;
    public final SpellStatus spellStatus;
    public final int width;
    public final SpellIcon spellTexture;
    public final FormattedCharSequence title;
    public final Font font;
    public SpellNodeWidget parent;
    public final LinkedList<SpellNodeWidget> children = new LinkedList();
    protected int x;
    protected int y;
    public final int frameIcon;
    public final int titleIcon;

    public SpellNodeWidget(SpellTreeTab skillTreeTab, SpellNode spell, SpellStatus spellStatus) {
        this.tab = skillTreeTab;
        this.spell = spell;
        this.spellStatus = spellStatus;
        this.font = Minecraft.m_91087_().f_91062_;
        this.spellTexture = spell.getSpell().getIcon();
        this.title = Language.m_128107_().m_5536_(this.font.m_92854_((FormattedText)spell.getSpell().getSpellName(), 163));
        this.x = 0;
        this.y = 0;
        this.width = 29 + this.font.m_92724_(this.title) + 3 + 5;
        SpellStatus status = ((SpellProgressionMenu)skillTreeTab.getScreen().m_6262_()).spellProgression.getOrDefault(spell.getSpell(), SpellStatus.LOCKED);
        int n = this.frameIcon = status == SpellStatus.FORGOTTEN ? 1 : 0;
        this.titleIcon = spellStatus == SpellStatus.LEARNED ? 0 : (ProgressionHelper.isFullyLinked(spell, ((SpellProgressionMenu)this.tab.getScreen().m_6262_()).spellProgression) ? 1 : 2);
    }

    private static float getMaxWidth(StringSplitter stringSplitter, List<FormattedText> list) {
        return (float)list.stream().mapToDouble(arg_0 -> ((StringSplitter)stringSplitter).m_92384_(arg_0)).max().orElse(0.0);
    }

    private List<FormattedText> findOptimalLines(Component component, int w) {
        StringSplitter splitter = this.font.m_92865_();
        List candidate = null;
        float smallest = Float.MAX_VALUE;
        for (int offset : TEXT_OFFSETS) {
            List split = splitter.m_92414_((FormattedText)component, w - offset, Style.f_131099_);
            float length = Math.abs(SpellNodeWidget.getMaxWidth(splitter, split) - (float)w);
            if (length <= 10.0f) {
                return split;
            }
            if (!(length < smallest)) continue;
            smallest = length;
            candidate = split;
        }
        return candidate;
    }

    public void drawLinkedConnectivity(PoseStack poseStack, int x, int y, int color, Predicate<SpellNodeWidget> childPredicate) {
        int xOff = 15;
        if (!this.children.isEmpty() && this.children.stream().anyMatch(childPredicate)) {
            int xMid = x + this.x + 15;
            int bot = y + this.y + 23;
            if (this.children.size() >= 2) {
                int hY = bot + 10;
                this.m_93222_(poseStack, xMid, bot, hY, color);
                for (SpellNodeWidget child : this.children) {
                    if (!childPredicate.test(child)) continue;
                    int childX = x + child.x + 15;
                    int childTop = y + child.y + 1;
                    this.m_93222_(poseStack, childX, childTop, hY, color);
                    this.m_93154_(poseStack, childX, xMid, hY, color);
                }
            } else {
                SpellNodeWidget child = this.children.getFirst();
                if (childPredicate.test(child)) {
                    int childX = x + child.x + 15;
                    int childTop = y + child.y + 1;
                    this.m_93222_(poseStack, childX, childTop, bot, color);
                }
            }
            for (SpellNodeWidget spellNodeWidget : this.children) {
                if (!childPredicate.test(spellNodeWidget)) continue;
                spellNodeWidget.drawLinkedConnectivity(poseStack, x, y, color, childPredicate);
            }
        }
    }

    public void drawBackgroundConnectivity(PoseStack poseStack, int x, int y) {
        int xOff = 15;
        if (!this.children.isEmpty()) {
            int xMid = x + this.x + 15;
            int bot = y + this.y + 23;
            int color = -16777216;
            if (this.children.size() >= 2) {
                int hX1 = x + this.children.getFirst().x + 15;
                int hX2 = x + this.children.getLast().x + 15;
                int hY = bot + 10;
                this.m_93222_(poseStack, xMid - 1, bot, hY + 1, color);
                this.m_93222_(poseStack, xMid + 1, bot, hY + 1, color);
                this.m_93154_(poseStack, hX1 - 1, hX2 + 1, hY - 1, color);
                this.m_93154_(poseStack, hX1 - 1, hX2 + 1, hY + 1, color);
                for (SpellNodeWidget child : this.children) {
                    int childX = x + child.x + 15;
                    int childTop = y + child.y + 1;
                    this.m_93222_(poseStack, childX - 1, childTop, hY - 1, color);
                    this.m_93222_(poseStack, childX + 1, childTop, hY - 1, color);
                }
            } else {
                SpellNodeWidget child = this.children.getFirst();
                int childX = x + child.x + 15;
                int childTop = y + child.y + 1;
                this.m_93222_(poseStack, childX - 1, childTop, bot, color);
                this.m_93222_(poseStack, childX + 1, childTop, bot, color);
            }
            for (SpellNodeWidget spellNodeWidget : this.children) {
                spellNodeWidget.drawBackgroundConnectivity(poseStack, x, y);
            }
        }
    }

    public void draw(PoseStack poseStack, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
        this.m_93228_(poseStack, x + this.x + 3, y + this.y, this.frameIcon * 26, 128 + (this.spellStatus.isAvailable() ? 0 : 1) * 26, 26, 26);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.spellTexture.getTexture());
        int offX = (18 - this.spellTexture.getWidth()) / 2;
        int offY = (18 - this.spellTexture.getHeight()) / 2;
        SpellNodeWidget.m_93160_((PoseStack)poseStack, (int)(x + this.x + 7 + offX), (int)(y + this.y + 4 + offY), (int)this.spellTexture.getWidth(), (int)this.spellTexture.getHeight(), (float)this.spellTexture.getU(), (float)this.spellTexture.getV(), (int)this.spellTexture.getWidth(), (int)this.spellTexture.getHeight(), (int)this.spellTexture.getTextureWidth(), (int)this.spellTexture.getTextureHeight());
        RenderSystem.m_69461_();
        for (SpellNodeWidget spellNodeWidget : this.children) {
            spellNodeWidget.draw(poseStack, x, y);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void addChild(SpellNodeWidget spellNodeWidget) {
        this.children.add(spellNodeWidget);
    }

    public void drawHover(PoseStack poseStack, int scrollX, int scrollY, int width, int height) {
        boolean drawLeft = width + scrollX + this.x + this.width + 26 >= this.tab.getScreen().f_96543_;
        int left = this.width / 2;
        int right = this.width - left;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS_LOCATION);
        int renderY = scrollY + this.y;
        int renderX = scrollX + this.x + (drawLeft ? 6 - this.width + 26 : 0);
        this.m_93228_(poseStack, renderX, renderY, 0, this.titleIcon * 26, left, 26);
        this.m_93228_(poseStack, renderX + left, renderY, 200 - right, this.titleIcon * 26, right, 26);
        this.m_93228_(poseStack, scrollX + this.x + 3, scrollY + this.y, this.frameIcon * 26, 128 + (this.spellStatus.isAvailable() ? 0 : 1) * 26, 26, 26);
        if (drawLeft) {
            this.font.m_92744_(poseStack, this.title, (float)(renderX + 5), (float)(scrollY + this.y + 9), -1);
        } else {
            this.font.m_92744_(poseStack, this.title, (float)(scrollX + this.x + 32), (float)(scrollY + this.y + 9), -1);
        }
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.spellTexture.getTexture());
        int offX = (18 - this.spellTexture.getWidth()) / 2;
        int offY = (18 - this.spellTexture.getHeight()) / 2;
        SpellNodeWidget.m_93160_((PoseStack)poseStack, (int)(scrollX + this.x + 7 + offX), (int)(scrollY + this.y + 4 + offY), (int)this.spellTexture.getWidth(), (int)this.spellTexture.getHeight(), (float)this.spellTexture.getU(), (float)this.spellTexture.getV(), (int)this.spellTexture.getWidth(), (int)this.spellTexture.getHeight(), (int)this.spellTexture.getTextureWidth(), (int)this.spellTexture.getTextureHeight());
        RenderSystem.m_69461_();
    }

    public boolean isMouseOver(int x, int y, int mouseX, int mouseY) {
        int minX = x + this.x;
        int maxX = minX + 26;
        int minY = y + this.y;
        int maxY = minY + 26;
        return mouseX >= minX && mouseX <= maxX && mouseY >= minY && mouseY <= maxY;
    }

    public void attachToParent() {
        if (this.parent == null && this.spell.getParent() != null) {
            this.parent = this.tab.getWidget(this.spell.getParent());
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }

    public void fixPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

