/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.SpellsRegistries;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public interface IRequirementType<R extends Requirement> {
    public R create(IRequirementType<R> var1);

    default public R makeInstance() {
        return this.create(this);
    }

    public static JsonObject writeToJson(Requirement requirement) {
        JsonObject json = new JsonObject();
        json.addProperty("type", SpellsRegistries.REQUIREMENTS_REGISTRY.get().getKey(requirement.getType()).toString());
        requirement.writeToJson(json);
        return json;
    }

    @Nullable
    public static Requirement readFromJson(JsonObject json) {
        String id = SpellsFileUtil.jsonString(json, "type");
        IRequirementType type = (IRequirementType)SpellsRegistries.REQUIREMENTS_REGISTRY.get().getValue(new ResourceLocation(id));
        if (type == null) {
            return null;
        }
        Object requirement = type.makeInstance();
        ((Requirement)requirement).readFromJson(json);
        return requirement;
    }

    public static void writeToBuf(FriendlyByteBuf buf, Requirement requirement) {
        buf.writeRegistryId(SpellsRegistries.REQUIREMENTS_REGISTRY.get(), requirement.getType());
        requirement.writeToBuf(buf);
    }

    public static Requirement readFromBuf(FriendlyByteBuf buf) {
        IRequirementType type = (IRequirementType)buf.readRegistryId();
        Object requirement = type.makeInstance();
        ((Requirement)requirement).readFromBuf(buf);
        return requirement;
    }
}

