/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.base.MultiIngredientSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class BaseIngredientsSpell
extends MultiIngredientSpell {
    public final List<ItemStack> defaultHandIngredients;
    public final List<ItemStack> defaultInventoryIngredients;
    protected List<ItemStack> handIngredients;
    protected List<ItemStack> inventoryIngredients;

    public BaseIngredientsSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients) {
        super(manaCost);
        this.defaultHandIngredients = ImmutableList.copyOf(handIngredients);
        this.defaultInventoryIngredients = ImmutableList.copyOf(inventoryIngredients);
    }

    public BaseIngredientsSpell(float manaCost, ItemStack handIngredient) {
        super(manaCost);
        this.defaultHandIngredients = ImmutableList.of((Object)handIngredient);
        this.defaultInventoryIngredients = ImmutableList.of();
    }

    public BaseIngredientsSpell(float manaCost) {
        super(manaCost);
        this.defaultHandIngredients = ImmutableList.of();
        this.defaultInventoryIngredients = ImmutableList.of();
    }

    @Override
    public List<ItemStack> getRequiredHandIngredients() {
        return this.handIngredients;
    }

    @Override
    public List<ItemStack> getRequiredInventoryIngredients() {
        return this.inventoryIngredients;
    }

    @Override
    public void consumeItemStacks(ManaHolder manaHolder, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients) {
        for (ItemStack required : this.getRequiredHandIngredients()) {
            handIngredients.stream().filter(itemStack -> itemStack.m_41720_() == required.m_41720_()).forEach(itemStack -> itemStack.m_41774_(required.m_41613_()));
        }
        for (ItemStack required : this.getRequiredInventoryIngredients()) {
            inventoryIngredients.stream().filter(itemStack -> itemStack.m_41720_() == required.m_41720_()).forEach(itemStack -> itemStack.m_41774_(required.m_41613_()));
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject o;
        JsonObject json = super.makeDefaultConfig();
        JsonArray handIngredients = new JsonArray();
        JsonArray inventoryIngredients = new JsonArray();
        for (ItemStack ingredient : this.defaultHandIngredients) {
            o = new JsonObject();
            SpellsFileUtil.jsonItemStack(o, ingredient);
            handIngredients.add((JsonElement)o);
        }
        for (ItemStack ingredient : this.defaultInventoryIngredients) {
            o = new JsonObject();
            SpellsFileUtil.jsonItemStack(o, ingredient);
            inventoryIngredients.add((JsonElement)o);
        }
        json.add("hand_ingredients", (JsonElement)handIngredients);
        json.add("inventory_ingredients", (JsonElement)inventoryIngredients);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        ItemStack ingredient;
        JsonObject o;
        super.readFromConfig(json);
        JsonArray handIngredients = SpellsFileUtil.jsonArray(json, "hand_ingredients");
        JsonArray inventoryIngredients = SpellsFileUtil.jsonArray(json, "inventory_ingredients");
        if (handIngredients.size() > 2) {
            throw new IllegalStateException();
        }
        if (inventoryIngredients.size() > 35) {
            throw new IllegalStateException();
        }
        this.handIngredients = new ArrayList<ItemStack>(handIngredients.size());
        this.inventoryIngredients = new ArrayList<ItemStack>(inventoryIngredients.size());
        for (JsonElement e : handIngredients) {
            if (!e.isJsonObject()) {
                throw new IllegalStateException();
            }
            o = e.getAsJsonObject();
            ingredient = SpellsFileUtil.jsonItemStack(o);
            this.handIngredients.add(ingredient);
        }
        for (JsonElement e : inventoryIngredients) {
            if (!e.isJsonObject()) {
                throw new IllegalStateException();
            }
            o = e.getAsJsonObject();
            ingredient = SpellsFileUtil.jsonItemStack(o);
            this.inventoryIngredients.add(ingredient);
        }
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.handIngredients = ImmutableList.copyOf(this.defaultHandIngredients);
        this.inventoryIngredients = ImmutableList.copyOf(this.defaultInventoryIngredients);
    }
}

