/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.base;

import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.spell.IEquipSpell;
import de.cas_ual_ty.spells.spell.ITickSpell;
import de.cas_ual_ty.spells.spell.base.AttributeSpell;
import de.cas_ual_ty.spells.spell.base.PassiveSpell;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class PermanentMobEffectSpell
extends PassiveSpell
implements ITickSpell,
IEquipSpell {
    public final MobEffect mobEffect;
    public final int duration;
    public final int amplifier;
    public final boolean ambient;
    public final boolean visible;
    public final boolean showIcon;

    public PermanentMobEffectSpell(MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        ResourceLocation rl = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        this.setIcon(new ResourceLocation(rl.m_135827_(), "textures/mob_effect/" + rl.m_135815_() + ".png"));
    }

    public PermanentMobEffectSpell(MobEffect mobEffect, int duration, int amplifier) {
        this(mobEffect, duration, amplifier, false, false, false);
    }

    public PermanentMobEffectSpell(MobEffect mobEffect, int duration) {
        this(mobEffect, duration, 0);
    }

    public PermanentMobEffectSpell(MobEffect mobEffect) {
        this(mobEffect, 20);
    }

    @Override
    public void onEquip(SpellHolder spellHolder, int slot) {
        this.tick(spellHolder, spellHolder.getAmountSpellEquipped(this));
    }

    @Override
    public void onUnequip(SpellHolder spellHolder, int slot) {
        MobEffectInstance activeEffect = spellHolder.getPlayer().m_21124_(this.mobEffect);
        if (activeEffect == null) {
            return;
        }
        if (activeEffect.m_19557_() <= this.duration + 1 && activeEffect.m_19564_() == this.amplifier && activeEffect.m_19571_() == this.ambient && activeEffect.m_19544_() == this.mobEffect) {
            spellHolder.getPlayer().m_21195_(this.mobEffect);
        }
    }

    @Override
    public void tick(SpellHolder spellHolder, int amount) {
        MobEffectInstance activeEffect = spellHolder.getPlayer().m_21124_(this.mobEffect);
        if (!spellHolder.getPlayer().f_19853_.f_46443_) {
            MobEffectInstance newEffect = new MobEffectInstance(this.mobEffect, this.duration + 1, this.amplifier, this.ambient, this.visible, this.showIcon);
            if (activeEffect != null) {
                if (activeEffect.m_19557_() == 1 && activeEffect.m_19564_() == this.amplifier && activeEffect.m_19571_() == this.ambient && activeEffect.m_19544_() == this.mobEffect) {
                    activeEffect.m_19558_(newEffect);
                }
            } else {
                spellHolder.getPlayer().m_7292_(newEffect);
            }
        }
    }

    @Override
    public MutableComponent getSpellName() {
        MutableComponent component = Component.m_237115_((String)this.mobEffect.m_19481_());
        if (this.amplifier > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + this.amplifier))});
        }
        return Component.m_237110_((String)this.getNameKey(), (Object[])new Object[]{component});
    }

    @Override
    public MutableComponent getSpellDesc() {
        MutableComponent component = Component.m_237115_((String)this.mobEffect.m_19481_());
        if (this.amplifier > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + this.amplifier))});
        }
        return Component.m_237110_((String)this.getDescKey(), (Object[])new Object[]{component.m_130940_(ChatFormatting.YELLOW)});
    }

    @Override
    public void addSpellDesc(List<Component> list) {
        list.add((Component)this.getSpellDesc());
        Map map = this.mobEffect.m_19485_();
        if (!map.isEmpty()) {
            list.add((Component)Component.m_237119_());
            list.add((Component)PermanentMobEffectSpell.whenAppliedComponent());
            for (Map.Entry entry : map.entrySet()) {
                Attribute attribute = (Attribute)entry.getKey();
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                attributeModifier = new AttributeModifier(attributeModifier.m_22214_(), this.mobEffect.m_7048_(this.amplifier, attributeModifier), attributeModifier.m_22217_());
                AttributeSpell.addTooltip(list, attribute, attributeModifier);
            }
        }
    }
}

