/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.impl;

import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.spell.impl.RandomTeleportSpell;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ForcedTeleportSpell
extends RandomTeleportSpell {
    public final int defaultRange;
    protected int range;

    public ForcedTeleportSpell(float manaCost, List<ItemStack> handIngredients, List<ItemStack> inventoryIngredients, int attempts, int teleportRange, int range) {
        super(manaCost, handIngredients, inventoryIngredients, attempts, teleportRange);
        this.defaultRange = range;
    }

    public ForcedTeleportSpell(float manaCost, ItemStack handIngredient, int attempts, int teleportRange, int range) {
        super(manaCost, handIngredient, attempts, teleportRange);
        this.defaultRange = range;
    }

    public ForcedTeleportSpell(float manaCost, int attempts, int teleportRange, int range) {
        super(manaCost, attempts, teleportRange);
        this.defaultRange = range;
    }

    public ForcedTeleportSpell() {
        this(10.0f, new ItemStack((ItemLike)Items.f_42730_), 5, 32, 20);
    }

    @Override
    public void perform(ManaHolder manaHolder) {
        EntityHitResult entityHit;
        Entity entity;
        Level level = manaHolder.getPlayer().f_19853_;
        LivingEntity entity2 = manaHolder.getPlayer();
        HitResult hit = SpellsUtil.rayTrace(level, (Entity)entity2, this.range, e -> e instanceof LivingEntity, 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE);
        if (hit.m_6662_() == HitResult.Type.ENTITY && (entity = (entityHit = (EntityHitResult)hit).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            ForcedTeleportSpell.randomTeleport(target, level, this.attempts, this.teleportRange);
        }
    }

    @Override
    public JsonObject makeDefaultConfig() {
        JsonObject json = super.makeDefaultConfig();
        json.addProperty("range", (Number)this.defaultRange);
        return json;
    }

    @Override
    public void readFromConfig(JsonObject json) {
        super.readFromConfig(json);
        this.range = SpellsFileUtil.jsonInt(json, "range");
    }

    @Override
    public void applyDefaultConfig() {
        super.applyDefaultConfig();
        this.range = this.defaultRange;
    }
}

