/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.serialization.Codec;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.worldgen.ConfigDensityFunction;
import dev.worldgen.tectonic.worldgen.DynamicReferenceDensityFunction;
import dev.worldgen.tectonic.worldgen.ErosionNoiseDensityFunction;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="tectonic")
public class TectonicForge {
    private static final List<String> enabledPacks = new ArrayList<String>();

    public TectonicForge() {
        Tectonic.init((Codec<HolderSet<DensityFunction>>)RegistryCodecs.m_206277_((ResourceKey)Registries.f_257040_));
        ConfigHandler.load(FMLPaths.CONFIGDIR.get().resolve("tectonic.json"));
        ConfigHandler.getConfig().enablePacks(ModList.get().isLoaded("terralith"), enabledPacks::add);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerDensityFunctionTypes);
        modEventBus.addListener(this::registerEnabledPacks);
    }

    private void registerDensityFunctionTypes(RegisterEvent event) {
        event.register(Registries.f_256746_, helper -> helper.register("config", ConfigDensityFunction.CODEC));
        event.register(Registries.f_256746_, helper -> helper.register("dynamic_reference", DynamicReferenceDensityFunction.CODEC));
        event.register(Registries.f_256746_, helper -> helper.register("erosion_noise", ErosionNoiseDensityFunction.CODEC));
    }

    private void registerEnabledPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (String packName : enabledPacks) {
                this.registerDatapack(event, packName);
            }
        }
    }

    private void registerDatapack(AddPackFindersEvent event, String packName) {
        boolean enableBullshitFix = packName.equals("increased_height");
        Path resourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/" + packName.toLowerCase()});
        Pack dataPack = Pack.m_245429_((String)("tectonic/" + (enableBullshitFix ? "z" : "") + packName.toLowerCase()), (Component)Component.m_237115_((String)("pack_name.tectonic." + packName)), (boolean)false, (Pack.ResourcesSupplier)TectonicForge.createSupplier((PackResources)new PathPackResources(resourcePath.getFileName().toString(), resourcePath, false)), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        event.addRepositorySource(packConsumer -> packConsumer.accept(dataPack));
    }

    protected static Pack.ResourcesSupplier createSupplier(final PackResources packResources) {
        return new Pack.ResourcesSupplier(){

            public PackResources open(@NotNull String string) {
                return packResources;
            }

            @NotNull
            public PackResources m_293078_(@NotNull String string) {
                return packResources;
            }

            @NotNull
            public PackResources m_247679_(@NotNull String string, // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull Pack.Info info) {
                return packResources;
            }
        };
    }
}

