/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.tectonic.config.ConfigHandler;
import net.minecraft.core.Holder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import org.jetbrains.annotations.NotNull;

public record ConfigDensityFunction(String option, Holder<DensityFunction> trueArgument, Holder<DensityFunction> falseArgument) implements DensityFunction
{
    public static Codec<ConfigDensityFunction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("option").forGetter(ConfigDensityFunction::option), (App)DensityFunction.CODEC.fieldOf("true_argument").orElse((Object)Holder.direct((Object)DensityFunctions.constant((double)1.0))).forGetter(ConfigDensityFunction::trueArgument), (App)DensityFunction.CODEC.fieldOf("false_argument").orElse((Object)Holder.direct((Object)DensityFunctions.zero())).forGetter(ConfigDensityFunction::falseArgument)).apply((Applicative)instance, ConfigDensityFunction::new));
    public static KeyDispatchDataCodec<ConfigDensityFunction> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(@NotNull DensityFunction.FunctionContext context) {
        if (this.option().equals("terrain_scale")) {
            return ConfigHandler.getConfig().getValue("terrain_scale");
        }
        boolean enabled = ConfigHandler.getConfig().getValue(this.option()) == 1.0;
        Holder<DensityFunction> toCompute = enabled ? this.trueArgument() : this.falseArgument();
        return ((DensityFunction)toCompute.value()).compute(context);
    }

    public void fillArray(double @NotNull [] doubles, DensityFunction.ContextProvider contextProvider) {
        contextProvider.fillAllDirectly(doubles, (DensityFunction)this);
    }

    @NotNull
    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)this);
    }

    public double minValue() {
        return -1.0E7;
    }

    public double maxValue() {
        return 1.0E7;
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

