/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleClaimant;
import net.tslat.tes.core.state.EntityState;

public final class TESParticleManager {
    private static final ConcurrentLinkedQueue<TESParticle<?>> PARTICLES = new ConcurrentLinkedQueue();
    private static final Object2ObjectOpenHashMap<class_2960, TESParticleClaimant> CLAIMANTS = new Object2ObjectOpenHashMap();
    private static final ConcurrentMap<Integer, List<Pair<class_2960, class_2487>>> CLAIMS = new ConcurrentHashMap<Integer, List<Pair<class_2960, class_2487>>>();
    private static final ObjectArrayList<Runnable> NEW_CLAIMS = new ObjectArrayList();

    public static void addParticle(TESParticle<?> particle) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        PARTICLES.add(particle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParticleClaimant(class_2960 id, TESParticleClaimant claimant) {
        Object2ObjectOpenHashMap<class_2960, TESParticleClaimant> object2ObjectOpenHashMap = CLAIMANTS;
        synchronized (object2ObjectOpenHashMap) {
            CLAIMANTS.put((Object)id, (Object)claimant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParticleClaim(int entityId, class_2960 claimantId, @Nullable class_2487 data) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        ObjectArrayList<Runnable> objectArrayList = NEW_CLAIMS;
        synchronized (objectArrayList) {
            NEW_CLAIMS.add(() -> CLAIMS.computeIfAbsent(entityId, key -> new ObjectArrayList()).add(Pair.of((Object)claimantId, (Object)data)));
        }
    }

    public static float handleParticleClaims(EntityState entityState, float healthDelta, Consumer<TESParticle<?>> particleAdder) {
        Pair pair;
        Iterator iterator = CLAIMS.getOrDefault(entityState.getEntity().method_5628(), List.of()).iterator();
        while (iterator.hasNext() && (healthDelta = ((TESParticleClaimant)CLAIMANTS.getOrDefault((pair = (Pair)iterator.next()).getFirst(), (state, delta, data, adder) -> delta)).checkClaim(entityState, healthDelta, (class_2487)pair.getSecond(), particleAdder)) != 0.0f) {
        }
        return healthDelta;
    }

    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (!TESAPI.getConfig().particlesEnabled()) {
            PARTICLES.clear();
            CLAIMS.clear();
            return;
        }
        if (!mc.method_1493()) {
            PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.tick(mc)));
            PARTICLES.removeIf(particle -> !particle.isValid());
        }
    }

    public static void clearClaims() {
        CLAIMS.clear();
        NEW_CLAIMS.forEach(Runnable::run);
        NEW_CLAIMS.clear();
    }

    public static void render(class_4587 poseStack, float partialTick) {
        class_310 mc = class_310.method_1551();
        class_327 fontRenderer = mc.field_1772;
        PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.render(poseStack, mc, fontRenderer, partialTick)));
    }
}

