/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.DamageParticle;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.particle.type.HealParticle;

public class EntityState {
    protected final class_1309 entity;
    protected Set<class_2960> effects;
    protected float currentHealth;
    protected float lastHealth;
    protected float lastTransitionHealth;
    protected long lastTransitionTime;

    public EntityState(class_1309 entity) {
        this.entity = entity;
        this.lastHealth = this.currentHealth = entity.method_6032();
        TESConstants.NETWORKING.requestEffectsSync(this.entity.method_5628());
    }

    public class_1309 getEntity() {
        return this.entity;
    }

    public float getHealth() {
        return this.currentHealth;
    }

    public float getLastHealth() {
        return this.lastHealth;
    }

    public float getLastTransitionHealth() {
        return this.lastTransitionHealth;
    }

    public float getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public Set<class_2960> getEffects() {
        return this.effects == null ? Set.of() : this.effects;
    }

    public void modifyEffects(Set<class_2960> ids, Set<class_2960> idsToRemove) {
        if (this.effects == null) {
            this.effects = new ObjectOpenHashSet(ids);
        } else {
            this.effects.addAll(ids);
        }
        this.effects.removeAll(idsToRemove);
    }

    public boolean isValid() {
        return this.entity != null && this.entity.method_5805() && this.entity.field_6002 == class_310.method_1551().field_1687;
    }

    public void tick() {
        this.currentHealth = Math.min(this.entity.method_6032(), this.entity.method_6063());
        if (this.currentHealth != this.lastHealth) {
            this.handleHealthChange();
        }
        this.lastHealth = this.currentHealth;
        if (this.entity.field_6002.method_8510() - this.lastTransitionTime > 20L) {
            if (this.lastTransitionHealth > this.currentHealth) {
                this.lastTransitionHealth -= this.entity.method_6063() / 30.0f;
            } else {
                this.lastTransitionTime = 0L;
                this.lastTransitionHealth = this.currentHealth;
            }
        }
    }

    protected void handleHealthChange() {
        if (TESAPI.getConfig().particlesEnabled()) {
            GenericTESParticle particle;
            float healthDelta = this.currentHealth - this.lastHealth;
            if (healthDelta != 0.0f) {
                healthDelta = TESParticleManager.handleParticleClaims(this, healthDelta, TESParticleManager::addParticle);
            }
            if (healthDelta == 0.0f) {
                return;
            }
            class_1160 particlePos = new class_1160((float)this.entity.method_23317(), (float)this.entity.method_23320(), (float)this.entity.method_23321());
            if (healthDelta < 0.0f) {
                this.lastTransitionTime = this.entity.field_6002.method_8510();
                if (this.lastTransitionHealth == 0.0f) {
                    this.lastTransitionHealth = this.lastHealth;
                }
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth <= 0.0f && this.lastHealth >= this.entity.method_6063() ? new ComponentParticle(this, particlePos, TESParticle.Animation.POP_OFF, (class_2561)new class_2588("config.tes.particle.verbal.instakill").method_10862(class_2583.field_24360.method_36139(TESAPI.getConfig().getDamageParticleColour()))) : new DamageParticle(this, particlePos, healthDelta * -1.0f);
            } else {
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth >= this.entity.method_6063() && this.lastHealth <= this.entity.method_6063() * 0.05f ? new ComponentParticle(this, particlePos, TESParticle.Animation.RISE, (class_2561)new class_2588("config.tes.particle.verbal.fullHeal").method_10862(class_2583.field_24360.method_36139(TESAPI.getConfig().getHealParticleColour()))) : new HealParticle(this, particlePos, healthDelta);
            }
            TESParticleManager.addParticle(particle);
        }
    }
}

