/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1074;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.tslat.tes.api.TESAPI;

public final class TESClientUtil {
    public static final class_2960 CREATIVE_INVENTORY_TEXTURE = new class_2960("textures/gui/container/creative_inventory/tab_inventory.png");

    public static void renderCenteredText(String text, class_4587 poseStack, class_327 fontRenderer, float x, float y, int colour) {
        TESClientUtil.renderCenteredText((class_2561)class_2561.method_43470((String)text), poseStack, fontRenderer, x, y, colour);
    }

    public static void renderCenteredText(class_2561 text, class_4587 poseStack, class_327 fontRenderer, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, text, x - (float)fontRenderer.method_27525((class_5348)text) / 2.0f, y + 4.0f, colour);
    }

    public static void positionFacingCamera(class_4587 poseStack) {
        poseStack.method_22907(class_310.method_1551().field_1773.method_19418().method_23767());
    }

    public static void prepRenderForTexture(class_2960 texture) {
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void constructBarRender(class_4587 poseStack, int x, int y, int width, int v, float percentComplete, boolean withBarOverlay, float opacity) {
        int percentPixels = Math.round(percentComplete * (float)width);
        int midBarWidth = width - 10;
        TESClientUtil.drawSimpleTexture(poseStack, x, y, Math.min(5, percentPixels), 5, 0.0f, v, 256);
        if (percentPixels > 5) {
            if (midBarWidth > 0) {
                TESClientUtil.drawSimpleTexture(poseStack, x + 5, y, Math.min(midBarWidth, percentPixels - 5), 5, 5.0f, v, 256);
            }
            if (percentPixels > width - 5) {
                TESClientUtil.drawSimpleTexture(poseStack, x + 5 + midBarWidth, y, Math.min(5, percentPixels - 5), 5, 177.0f, v, 256);
            }
        }
        if (withBarOverlay && width > 10) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * opacity));
            TESClientUtil.drawSimpleTexture(poseStack, x, y, width, 5, 0.0f, 80.0f, 182, 5, 256, 256);
        }
    }

    public static void renderEntityIcon(class_4587 poseStack, class_310 mc, float partialTick, class_1309 entity, float opacity, boolean includeFrame) {
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.method_17681(), 40.0f / entity.method_17682()), 0.95f);
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        poseStack.method_22903();
        if (includeFrame) {
            TESClientUtil.prepRenderForTexture(CREATIVE_INVENTORY_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * opacity));
            TESClientUtil.drawSimpleTexture(poseStack, 2, 2, 34, 45, 72.0f, 5.0f, 256);
            poseStack.method_22904(20.0, 25.0, 0.0);
            poseStack.method_22905(-20.0f, -20.0f, 20.0f);
        }
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_22904(0.0, (double)(entity.method_17682() * -0.5f), (double)entity.method_17681());
        float yBodyRotPrev = entity.field_6283;
        float yRotPrev = entity.method_36454();
        float xRotPrev = entity.method_36455();
        float yHeadRotOldPrev = entity.field_6259;
        float yHeadRotPrev = entity.field_6241;
        int hurtTicks = entity.field_6235;
        float limbSwingPrev = entity.field_6249;
        float attackTimePrev = entity.field_6251;
        float attackTimeOldPrev = entity.field_6229;
        float animSpeedPrev = entity.field_6225;
        float animSpeedOldPrev = entity.field_6211;
        entity.method_36456(22.5f);
        entity.method_36457(0.0f);
        entity.field_6283 = 22.5f;
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        entity.field_6235 = TESAPI.getConfig().hudEntityDamageOverlay() ? entity.field_6235 : 0;
        entity.field_6249 = 0.0f;
        entity.field_6251 = 0.0f;
        entity.field_6229 = 0.0f;
        class_308.method_34742();
        RenderSystem.runAsFancy(() -> TESClientUtil.renderEntityRaw(poseStack, entity, partialTick, 0.0f, 0xF000F0, (class_4597)bufferSource));
        bufferSource.method_22993();
        class_308.method_24211();
        entity.method_36456(yRotPrev);
        entity.method_36457(xRotPrev);
        entity.field_6283 = yBodyRotPrev;
        entity.field_6241 = yHeadRotPrev;
        entity.field_6259 = yHeadRotOldPrev;
        entity.field_6235 = hurtTicks;
        entity.field_6249 = limbSwingPrev;
        entity.field_6251 = attackTimePrev;
        entity.field_6229 = attackTimeOldPrev;
        poseStack.method_22909();
    }

    public static <T extends class_1297> void renderEntityRaw(class_4587 poseStack, T entity, float partialTick, float rotYaw, int packedLight, class_4597 bufferSource) {
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953(entity);
        try {
            class_243 renderOffset = entityRenderer.method_23169(entity, partialTick);
            poseStack.method_22903();
            poseStack.method_22904(renderOffset.field_1352, renderOffset.field_1351, renderOffset.field_1350);
            entityRenderer.method_3936(entity, rotYaw, 1.0f, poseStack, bufferSource, packedLight);
            poseStack.method_22909();
        }
        catch (Exception ex) {
            class_128 wrappedReport = class_128.method_560((Throwable)ex, (String)"Rendering entity in world");
            class_129 entityReportCategory = wrappedReport.method_562("Entity being rendered");
            entity.method_5819(entityReportCategory);
            class_129 rendererReportCategory = wrappedReport.method_562("Renderer details");
            rendererReportCategory.method_578("Assigned renderer", (Object)entityRenderer);
            throw new class_148(wrappedReport);
        }
    }

    public static void drawSimpleTexture(class_4587 poseStack, int posX, int posY, int width, int height, float u, float v, int pngSize) {
        TESClientUtil.drawSimpleTexture(poseStack, posX, posY, width, height, u, v, width, height, pngSize, pngSize);
    }

    public static void drawSimpleTexture(class_4587 poseStack, int posX, int posY, int width, int height, float u, float v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        class_329.method_25293((class_4587)poseStack, (int)posX, (int)posY, (int)width, (int)height, (float)u, (float)v, (int)uWidth, (int)vHeight, (int)pngWidth, (int)pngHeight);
    }

    public static void drawText(class_4587 poseStack, String text, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, (class_2561)class_2561.method_43470((String)text), x, y, colour);
    }

    public static void drawText(class_4587 poseStack, class_2561 text, float x, float y, int colour) {
        class_310.method_1551().field_1772.method_30883(poseStack, text, x, y, colour);
    }

    public static void drawTextWithShadow(class_4587 poseStack, String text, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, (class_2561)class_2561.method_43470((String)text), x, y, colour);
    }

    public static void drawTextWithShadow(class_4587 poseStack, class_2561 text, float x, float y, int colour) {
        class_310.method_1551().field_1772.method_30881(poseStack, text, x, y, colour);
    }

    public static void drawColouredSquare(class_4587 poseStack, int posX, int posY, int width, int height, int colour) {
        class_329.method_25294((class_4587)poseStack, (int)posX, (int)posY, (int)(posX + width), (int)(posY + height), (int)colour);
    }

    public static String translateKey(String key, Object ... args) {
        return class_1074.method_4662((String)key, (Object[])args);
    }

    public static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }
}

