/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESHudElement;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.config.TESConfig;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.particle.TESParticleClaimant;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.NumericParticle;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;
import net.tslat.tes.networking.TESNetworking;

public final class TESAPI {
    public static void addTESParticle(TESParticle<?> particle) {
        TESParticleManager.addParticle(particle);
    }

    public static void addTESHudElement(ResourceLocation id, TESHudElement element) {
        TESHud.addHudElement(id.toString(), element);
    }

    public static boolean removeTESHudElement(ResourceLocation id) {
        return TESHud.removeHudElement(id.toString());
    }

    public static void registerParticleClaimant(ResourceLocation id, TESParticleClaimant claimant) {
        TESParticleManager.registerParticleClaimant(id, claimant);
    }

    public static TESConfig getConfig() {
        return TESConstants.CONFIG;
    }

    @Nullable
    public static LivingEntity getCurrentHUDTarget() {
        return TESHud.getTargetEntity();
    }

    @Nullable
    public static EntityState getTESDataForEntity(LivingEntity entity) {
        return TESAPI.getTESDataForEntity(entity.func_145782_y());
    }

    @Nullable
    public static EntityState getTESDataForEntity(int entityId) {
        return TESEntityTracking.getStateForEntityId(entityId);
    }

    public static void submitParticleClaim(ResourceLocation id, LivingEntity targetEntity, @Nullable CompoundNBT additionalData) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESNetworking.sendParticleClaim(id, targetEntity, additionalData);
        } else {
            TESParticleManager.addParticleClaim(targetEntity.func_145782_y(), id, additionalData);
        }
    }

    public static void addTESParticle(World level, Vector3f position, ITextComponent contents) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESNetworking.sendParticle(level, position, contents);
        } else {
            TESParticleManager.addParticle(new ComponentParticle(null, position, contents));
        }
    }

    public static void addTESParticle(LivingEntity targetedEntity, ITextComponent contents) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESNetworking.sendParticle(targetedEntity, contents);
        } else {
            EntityState entityState = TESAPI.getTESDataForEntity(targetedEntity);
            if (entityState != null) {
                TESParticleManager.addParticle(new ComponentParticle(entityState, new Vector3f(targetedEntity.func_174824_e(1.0f)), contents));
            }
        }
    }

    public static void sendParticle(World level, Vector3f position, double value, int colour) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESNetworking.sendParticle(level, position, value, colour);
        } else {
            TESParticleManager.addParticle(new NumericParticle(null, position, value).withColour(colour));
        }
    }

    public static void sendParticle(LivingEntity targetedEntity, double value, int colour) {
        if (TESConstants.IS_SERVER_SIDE) {
            TESNetworking.sendParticle(targetedEntity, value, colour);
        } else {
            EntityState entityState = TESAPI.getTESDataForEntity(targetedEntity);
            if (entityState != null) {
                TESParticleManager.addParticle(new NumericParticle(entityState, new Vector3f(targetedEntity.func_174824_e(1.0f)), value).withColour(colour));
            }
        }
    }
}

