/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.vector.Vector3f;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.util.TESClientUtil;

public interface TESParticle<D> {
    public void updateData(D var1);

    public void render(MatrixStack var1, Minecraft var2, FontRenderer var3, float var4);

    public void tick(Minecraft var1);

    public boolean isValid();

    default public void defaultedTextRender(Minecraft mc, MatrixStack poseStack, Vector3f prevPos, Vector3f pos, float partialTick, Runnable renderCallback) {
        float scale = 0.035f * TESAPI.getConfig().getParticleScale();
        ActiveRenderInfo camera = mc.field_71460_t.func_215316_n();
        Vector3f renderPos = prevPos.func_229195_e_();
        renderPos.func_229190_a_(pos, partialTick);
        renderPos.func_195897_a(new Vector3f(camera.func_216785_c()));
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)renderPos.func_195899_a(), (double)renderPos.func_195900_b(), (double)renderPos.func_195902_c());
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        poseStack.func_227862_a_(scale, scale, scale);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        renderCallback.run();
        RenderSystem.disableBlend();
        poseStack.func_227865_b_();
    }

    public static abstract class Animation {
        public static final Animation POP_OFF = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                return new Vector3f((float)random.nextGaussian() * 0.03f + 0.025f, random.nextFloat() * 0.045f + 0.3f, (float)random.nextGaussian() * 0.03f + 0.025f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.func_195897_a(new Vector3f(0.0f, 0.05f, 0.0f));
                pos.func_229189_a_(velocity);
            }
        };
        public static final Animation RISE = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                position.func_195904_b((float)random.nextGaussian() * 0.05f, 0.1f, (float)random.nextGaussian() * 0.05f);
                return new Vector3f(0.0f, 0.2f, 0.0f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.func_195897_a(new Vector3f(0.0f, 0.02f, 0.0f));
                pos.func_229189_a_(velocity);
            }
        };

        public abstract Vector3f getInitialVelocity(TESParticle<?> var1, Vector3f var2, Random var3);

        public abstract void perTickModifier(TESParticle<?> var1, int var2, Vector3f var3, Vector3f var4, Vector3f var5, Random var6);
    }
}

