/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.tslat.tes.api.TESAPI;

public final class TESClientUtil {
    public static final ResourceLocation CREATIVE_INVENTORY_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tab_inventory.png");

    public static void renderCenteredText(String text, MatrixStack poseStack, FontRenderer fontRenderer, float x, float y, int colour) {
        TESClientUtil.renderCenteredText((ITextComponent)new StringTextComponent(text), poseStack, fontRenderer, x, y, colour);
    }

    public static void renderCenteredText(ITextComponent text, MatrixStack poseStack, FontRenderer fontRenderer, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y + 4.0f, colour);
    }

    public static void positionFacingCamera(MatrixStack poseStack) {
        poseStack.func_227863_a_(Minecraft.func_71410_x().field_71460_t.func_215316_n().func_227995_f_());
    }

    public static void prepRenderForTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void constructBarRender(MatrixStack poseStack, int x, int y, int width, int v, float percentComplete, boolean withBarOverlay, float opacity) {
        int percentPixels = Math.round(percentComplete * (float)width);
        int midBarWidth = width - 10;
        TESClientUtil.drawSimpleTexture(poseStack, x, y, Math.min(5, percentPixels), 5, 0.0f, v, 256);
        if (percentPixels > 5) {
            if (midBarWidth > 0) {
                TESClientUtil.drawSimpleTexture(poseStack, x + 5, y, Math.min(midBarWidth, percentPixels - 5), 5, 5.0f, v, 256);
            }
            if (percentPixels > width - 5) {
                TESClientUtil.drawSimpleTexture(poseStack, x + 5 + midBarWidth, y, Math.min(5, percentPixels - 5), 5, 177.0f, v, 256);
            }
        }
        if (withBarOverlay && width > 10) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * opacity));
            TESClientUtil.drawSimpleTexture(poseStack, x, y, width, 5, 0.0f, 80.0f, 182, 5, 256, 256);
        }
    }

    public static void renderEntityIcon(MatrixStack poseStack, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean includeFrame) {
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.func_213311_cf(), 40.0f / entity.func_213302_cg()), 0.95f);
        IRenderTypeBuffer.Impl bufferSource = mc.func_228019_au_().func_228487_b_();
        poseStack.func_227860_a_();
        if (includeFrame) {
            TESClientUtil.prepRenderForTexture(CREATIVE_INVENTORY_TEXTURE);
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * opacity));
            TESClientUtil.drawSimpleTexture(poseStack, 2, 2, 34, 45, 72.0f, 5.0f, 256);
            poseStack.func_227861_a_(20.0, 25.0, 0.0);
            poseStack.func_227862_a_(-20.0f, -20.0f, 20.0f);
        }
        poseStack.func_227862_a_(scale, scale, scale);
        poseStack.func_227861_a_(0.0, (double)(entity.func_213302_cg() * -0.5f), (double)entity.func_213311_cf());
        float yBodyRotPrev = entity.field_70761_aq;
        float yRotPrev = entity.field_70177_z;
        float xRotPrev = entity.field_70125_A;
        float yHeadRotOldPrev = entity.field_70758_at;
        float yHeadRotPrev = entity.field_70759_as;
        int hurtTicks = entity.field_70737_aN;
        float limbSwingPrev = entity.field_184619_aG;
        float limbSwingSpeedPrev = entity.field_70721_aZ;
        float attackTimePrev = entity.field_70733_aJ;
        float attackTimeOldPrev = entity.field_70732_aI;
        entity.field_70177_z = 22.5f;
        entity.field_70125_A = 0.0f;
        entity.field_70761_aq = 22.5f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        entity.field_70737_aN = TESAPI.getConfig().hudEntityDamageOverlay() ? entity.field_70737_aN : 0;
        entity.field_184619_aG = 0.0f;
        entity.field_70721_aZ = 0.0f;
        entity.field_70733_aJ = 0.0f;
        entity.field_70732_aI = 0.0f;
        RenderSystem.runAsFancy(() -> TESClientUtil.renderEntityRaw(poseStack, entity, partialTick, 0.0f, 0xF000F0, (IRenderTypeBuffer)bufferSource));
        bufferSource.func_228461_a_();
        entity.field_70177_z = yRotPrev;
        entity.field_70125_A = xRotPrev;
        entity.field_70761_aq = yBodyRotPrev;
        entity.field_70759_as = yHeadRotPrev;
        entity.field_70758_at = yHeadRotOldPrev;
        entity.field_70737_aN = hurtTicks;
        entity.field_184619_aG = limbSwingPrev;
        entity.field_70721_aZ = limbSwingSpeedPrev;
        entity.field_70733_aJ = attackTimePrev;
        entity.field_70732_aI = attackTimeOldPrev;
        poseStack.func_227865_b_();
    }

    public static <T extends Entity> void renderEntityRaw(MatrixStack poseStack, T entity, float partialTick, float rotYaw, int packedLight, IRenderTypeBuffer bufferSource) {
        EntityRendererManager entityRenderDispatcher = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer entityRenderer = entityRenderDispatcher.func_78713_a(entity);
        try {
            Vector3d renderOffset = entityRenderer.func_225627_b_(entity, partialTick);
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(renderOffset.field_72450_a, renderOffset.field_72448_b, renderOffset.field_72449_c);
            entityRenderer.func_225623_a_(entity, rotYaw, 1.0f, poseStack, bufferSource, packedLight);
            poseStack.func_227865_b_();
        }
        catch (Exception ex) {
            CrashReport wrappedReport = CrashReport.func_85055_a((Throwable)ex, (String)"Rendering entity in world");
            CrashReportCategory entityReportCategory = wrappedReport.func_85058_a("Entity being rendered");
            entity.func_85029_a(entityReportCategory);
            CrashReportCategory rendererReportCategory = wrappedReport.func_85058_a("Renderer details");
            rendererReportCategory.func_71507_a("Assigned renderer", (Object)entityRenderer);
            throw new ReportedException(wrappedReport);
        }
    }

    public static void drawSimpleTexture(MatrixStack poseStack, int posX, int posY, int width, int height, float u, float v, int pngSize) {
        TESClientUtil.drawSimpleTexture(poseStack, posX, posY, width, height, u, v, width, height, pngSize, pngSize);
    }

    public static void drawSimpleTexture(MatrixStack poseStack, int posX, int posY, int width, int height, float u, float v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Screen.func_238466_a_((MatrixStack)poseStack, (int)posX, (int)posY, (int)width, (int)height, (float)u, (float)v, (int)uWidth, (int)vHeight, (int)pngWidth, (int)pngHeight);
    }

    public static void drawText(MatrixStack poseStack, String text, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, (ITextComponent)new StringTextComponent(text), x, y, colour);
    }

    public static void drawText(MatrixStack poseStack, ITextComponent text, float x, float y, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_243248_b(poseStack, text, x, y, colour);
    }

    public static void drawTextWithShadow(MatrixStack poseStack, String text, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, (ITextComponent)new StringTextComponent(text), x, y, colour);
    }

    public static void drawTextWithShadow(MatrixStack poseStack, ITextComponent text, float x, float y, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_243246_a(poseStack, text, x, y, colour);
    }

    public static void drawColouredSquare(MatrixStack poseStack, int posX, int posY, int width, int height, int colour) {
        Screen.func_238467_a_((MatrixStack)poseStack, (int)posX, (int)posY, (int)(posX + width), (int)(posY + height), (int)colour);
    }

    public static String translateKey(String key, Object ... args) {
        return I18n.func_135052_a((String)key, (Object[])args);
    }

    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static int packColour(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

