/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.SwordItem;
import net.minecraft.util.Hand;
import net.minecraftforge.entity.PartEntity;
import net.tslat.tes.api.TESEntityType;

public class TESUtil {
    private static final Object2BooleanOpenHashMap<Class<? extends LivingEntity>> meleeMobs = new Object2BooleanOpenHashMap();
    private static final Object2BooleanOpenHashMap<Class<? extends LivingEntity>> rangedMobs = new Object2BooleanOpenHashMap();
    private static final Map<Class<? extends LivingEntity>, TESEntityType> ENTITY_TYPE_MAP = new Object2ObjectOpenHashMap();

    public static String roundToDecimal(double value, int decimals) {
        float val = (float)Math.round(value * (double)((float)Math.pow(10.0, decimals))) / (float)Math.pow(10.0, decimals);
        if ((float)((int)val) == val) {
            return String.valueOf((int)val);
        }
        return String.valueOf(val);
    }

    public static float getHealthPercent(LivingEntity entity) {
        return entity.func_110143_aJ() / entity.func_110138_aP();
    }

    public static int getArmour(LivingEntity entity) {
        if (entity.func_233645_dx_().func_233790_b_(Attributes.field_233826_i_)) {
            return (int)Math.floor(entity.func_233637_b_(Attributes.field_233826_i_));
        }
        return 0;
    }

    public static float getArmourToughness(LivingEntity entity) {
        if (entity.func_233645_dx_().func_233790_b_(Attributes.field_233827_j_)) {
            return (float)entity.func_233637_b_(Attributes.field_233827_j_);
        }
        return 0.0f;
    }

    public static boolean isFireImmune(Entity entity) {
        return entity.func_200600_R().func_220338_c();
    }

    public static boolean isMeleeMob(LivingEntity entity) {
        return TESUtil.isMeleeMobHardcoded(entity);
    }

    public static boolean isRangedMob(LivingEntity entity) {
        return TESUtil.isRangedMobHardcoded(entity);
    }

    public static boolean isVisibleToPlayer(@Nullable LivingEntity entity, PlayerEntity player) {
        return entity != null && (!entity.func_98034_c(player) || entity.func_225510_bt_());
    }

    @Nullable
    public static LivingEntity getLivingEntityIfPossible(@Nullable Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof ArmorStandEntity) {
                return null;
            }
            return livingEntity;
        }
        if (entity instanceof PartEntity && ((PartEntity)entity).getParent() instanceof LivingEntity) {
            return (LivingEntity)((PartEntity)entity).getParent();
        }
        return null;
    }

    public static TESEntityType getEntityType(LivingEntity entity) {
        return ENTITY_TYPE_MAP.computeIfAbsent(entity.getClass(), clazz -> {
            if (entity.func_200600_R() == EntityType.field_200729_aH) {
                return TESEntityType.PLAYER;
            }
            if (!entity.func_184222_aU()) {
                return TESEntityType.BOSS;
            }
            if (entity instanceof IAngerable) {
                return TESEntityType.NEUTRAL;
            }
            if (entity instanceof MonsterEntity) {
                return TESEntityType.HOSTILE;
            }
            return TESEntityType.PASSIVE;
        });
    }

    public static boolean isMeleeMobHardcoded(LivingEntity entity) {
        return (Boolean)meleeMobs.computeIfAbsent(entity.getClass(), clazz -> {
            if (!entity.func_233645_dx_().func_233790_b_(Attributes.field_233823_f_)) {
                return false;
            }
            if (entity.func_233638_c_(Attributes.field_233823_f_) != 2.0) {
                return true;
            }
            if (entity instanceof AbstractSkeletonEntity) {
                return entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof SwordItem;
            }
            if (entity instanceof PhantomEntity || entity instanceof EnderDragonEntity || entity instanceof SpiderEntity || entity instanceof SlimeEntity || entity instanceof EndermiteEntity || entity instanceof SilverfishEntity) {
                return true;
            }
            return false;
        });
    }

    public static boolean isRangedMobHardcoded(LivingEntity entity) {
        return (Boolean)rangedMobs.computeIfAbsent(entity.getClass(), clazz -> {
            if (entity instanceof IRangedAttackMob) {
                return true;
            }
            if (entity instanceof BlazeEntity || entity instanceof ShulkerEntity || entity instanceof GhastEntity || entity instanceof GuardianEntity) {
                return true;
            }
            if (entity instanceof AbstractSkeletonEntity) {
                return entity.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof BowItem;
            }
            return false;
        });
    }
}

