/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESHUDActivation;
import net.tslat.tes.core.hud.TESHud;
import org.apache.commons.lang3.tuple.Pair;

public final class TESConfig {
    private final ForgeConfigSpec.DoubleValue entityTrackingDistance;
    private final ForgeConfigSpec.IntValue cacheCleanFrequency;
    private final ForgeConfigSpec.BooleanValue hudEnabled;
    private final ForgeConfigSpec.DoubleValue hudTargetDistance;
    private final ForgeConfigSpec.IntValue hudTargetGracePeriod;
    private final ForgeConfigSpec.BooleanValue hudEntityRender;
    private final ForgeConfigSpec.EnumValue<TESHud.BarRenderType> hudHealthRenderType;
    private final ForgeConfigSpec.BooleanValue hudHealthBarSegments;
    private final ForgeConfigSpec.IntValue hudHealthBarLength;
    private final ForgeConfigSpec.BooleanValue hudEntityDamageTint;
    private final ForgeConfigSpec.BooleanValue hudEntityName;
    private final ForgeConfigSpec.BooleanValue hudBossesEnabled;
    private final ForgeConfigSpec.BooleanValue hudArmour;
    private final ForgeConfigSpec.BooleanValue hudEntityIcons;
    private final ForgeConfigSpec.BooleanValue hudPotionIcons;
    private final ForgeConfigSpec.DoubleValue hudOpacity;
    private final ForgeConfigSpec.DoubleValue hudBarFontBackingOpacity;
    private final ForgeConfigSpec.BooleanValue inWorldBarsEnabled;
    private final ForgeConfigSpec.BooleanValue inWorldHudForSelf;
    private final ForgeConfigSpec.EnumValue<TESHUDActivation> inWorldHUDActivation;
    private final ForgeConfigSpec.DoubleValue inWorldHudOpacity;
    private final ForgeConfigSpec.EnumValue<TESHud.BarRenderType> inWorldBarsRenderType;
    private final ForgeConfigSpec.IntValue inWorldBarsLength;
    private final ForgeConfigSpec.BooleanValue inWorldBarsSegments;
    private final ForgeConfigSpec.BooleanValue inWorldHudEntityName;
    private final ForgeConfigSpec.BooleanValue inWorldHudArmour;
    private final ForgeConfigSpec.BooleanValue inWorldHudEntityIcons;
    private final ForgeConfigSpec.BooleanValue inWorldHudPotionIcons;
    private final ForgeConfigSpec.BooleanValue inWorldHudNameOverride;
    private final ForgeConfigSpec.DoubleValue inWorldHudManualVerticalOffset;
    private final ForgeConfigSpec.BooleanValue particlesEnabled;
    private final ForgeConfigSpec.IntValue particleDecimalPoints;
    private final ForgeConfigSpec.DoubleValue particleScale;
    private final ForgeConfigSpec.BooleanValue verbalHealthParticles;
    private final ForgeConfigSpec.IntValue damageParticleColour;
    private final ForgeConfigSpec.IntValue healParticleColour;

    public TESConfig(ForgeConfigSpec.Builder config) {
        config.push("General Settings");
        this.entityTrackingDistance = config.comment("How close (in blocks) entities should be before TES starts tracking them").translation("config.tes.general.entityTrackingDistance").defineInRange("entityTrackingDistance", 64.0, 8.0, 512.0);
        this.cacheCleanFrequency = config.comment("How frequently TES should clear out its tracking cache. Generally this should stay at default, but if you are noticing issues you can try adjusting it").translation("config.tes.general.cacheCleanFrequency").defineInRange("cacheCleanFrequency", 400, 20, Integer.MAX_VALUE);
        config.pop();
        config.push("HUD Settings");
        this.hudEnabled = config.comment("Whether the TES HUD should be enabled or not").translation("config.tes.hud.enabled").define("hudEnabled", true);
        this.hudTargetDistance = config.comment(new String[]{"How close (in blocks) the player has to be to render a HUD for an entity under the crosshairs", "Larger values may cost more performance"}).translation("config.tes.hud.targetDistance").defineInRange("hudTargetDistance", 64.0, 4.0, 256.0);
        this.hudTargetGracePeriod = config.comment("How long (in ticks) after looking away from an entity before its HUD should stop rendering").translation("config.tes.hud.targetGracePeriod").defineInRange("hudTargetGracePeriod", 10, 0, Integer.MAX_VALUE);
        this.hudEntityRender = config.comment("Whether the TES HUD should render the entity's image").translation("config.tes.hud.entityRender").define("hudEntityRender", true);
        this.hudHealthRenderType = config.comment(new String[]{"Select the health render type for the TES HUD", "Options:", "NUMERIC - Use numeric values for health only", "BAR - Use a health-bar style render", "COMBINED - Use a health-bar style render with numeric values overlaid"}).translation("config.tes.hud.healthRenderType").defineEnum("healthRenderType", (Enum)TESHud.BarRenderType.COMBINED);
        this.hudHealthBarSegments = config.comment("Set whether the TES HUD health bar should render bar-segments").translation("config.tes.hud.healthBarSegments").define("hudHealthBarSegments", true);
        this.hudHealthBarLength = config.comment("Set how long the TES HUD health bar should be").translation("config.tes.hud.healthBarLength").defineInRange("hudHealthBarLength", 100, 10, Integer.MAX_VALUE);
        this.hudEntityDamageTint = config.comment("Set whether the TES HUD's entity icon should keep the red 'tint' entities get when the real entity takes damage or not").translation("config.tes.hud.entityDamageTint").define("hudEntityDamageTint", false);
        this.hudEntityName = config.comment("Whether the TES HUD should render the entity's name").translation("config.tes.hud.entityName").define("hudEntityName", true);
        this.hudBossesEnabled = config.comment("Whether the TES HUD should render if the entity is a boss (they usually have their own boss bars)").translation("config.tes.hud.bossesEnabled").define("hudBossesEnabled", true);
        this.hudArmour = config.comment("Whether the TES HUD should render the entity's armour and toughness").translation("config.tes.hud.armour").define("hudArmour", true);
        this.hudEntityIcons = config.comment("Whether the TES HUD should render the entity's alignment icons").translation("config.tes.hud.entityIcons").define("hudEntityName", true);
        this.hudPotionIcons = config.comment("Whether the TES HUD should render the entity's effect icons").translation("config.tes.hud.potionIcons").define("hudPotionIcons", true);
        this.hudOpacity = config.comment("Set how opaque the TES HUD should be, overall. The lower the value, the more transparent the HUD will be").translation("config.tes.hud.opacity").defineInRange("hudOpacity", 1.0, 0.0, 1.0);
        this.hudBarFontBackingOpacity = config.comment("Set how opaque the background behind the text on TES bars, if a render type is set that renders text").translation("config.tes.hud.barFontBackingOpacity").defineInRange("hudBarFontBackingOpacity", 0.5, 0.0, 1.0);
        config.pop();
        config.push("In-World Bars Settings");
        this.inWorldBarsEnabled = config.comment("Whether TES should do in-world entity status bars").translation("config.tes.inWorldHud.enabled").define("inWorldBarsEnabled", true);
        this.inWorldHudForSelf = config.comment("Whether the TES in-world HUD should be enabled for the player or not").translation("config.tes.hud.self").define("inWorldHudForSelf", false);
        this.inWorldHUDActivation = config.comment(new String[]{"When the TES in-world status bars should render", "Options:", "ALWAYS - Any entity currently visible", "NEARBY_ONLY - Only entities nearby", "DAMAGED_ONLY - Only entities that have less than full health", "DAMAGED_AND_NEARBY - Only entities that are nearby and have less than full health", "LOOKING_AT - Only the currently targeted entity", "LOOKING_AT_AND_DAMAGED - Only the currently targeted entity, if it has less than full health", "LOOKING_AT_NEARBY_AND_DAMAGED - Only the currently targeted entity if it is nearby and has less than full health", "NOT_LOOKING_AT - Only when the entity isn't the one being rendered for the on-screen HUD", "NOT_LOOKING_AT_AND_DAMAGED - Only if not the currently targeted entity, if it has less than full health", "NOT_LOOKING_AT_NEARBY_AND_DAMAGED - Only if not the currently targeted entity, it is nearby and has less than full health"}).translation("config.tes.inWorldHud.activation").defineEnum("inWorldHudActivation", (Enum)TESHUDActivation.DAMAGED_AND_NEARBY);
        this.inWorldBarsRenderType = config.comment(new String[]{"Select the bar render type for the in-game TES entity status HUD", "Options:", "NUMERIC - Use numeric values only", "BAR - Use a health-bar style render", "COMBINED - Use a health-bar style render with numeric values overlaid"}).translation("config.tes.inWorldHud.barsRenderType").defineEnum("inWorldBarsRenderType", (Enum)TESHud.BarRenderType.BAR);
        this.inWorldHudOpacity = config.comment("How opaque the TES in-world entity HUD should be.").translation("config.tes.inWorldHud.opacity").defineInRange("inWorldHudOpacity", 1.0, 0.0, 1.0);
        this.inWorldBarsLength = config.comment("Set how long the TES in-world entity status bars should be").translation("config.tes.inWorldHud.barLength").defineInRange("inWorldBarsLength", 50, 10, Integer.MAX_VALUE);
        this.inWorldBarsSegments = config.comment("Whether the in-world entity status bars should be segmented").translation("config.tes.inWorldHud.barSegments").define("inWorldBarsSegments", true);
        this.inWorldHudEntityName = config.comment("Whether the in-world entity status HUD should render the entity's name").translation("config.tes.inWorldHud.entityName").define("inWorldHudEntityName", false);
        this.inWorldHudArmour = config.comment("Whether the in-world entity status HUD should render the entity's armour values").translation("config.tes.inWorldHud.armour").define("inWorldHudArmour", false);
        this.inWorldHudEntityIcons = config.comment("Whether the in-world entity status HUD should render the entity's alignment icons").translation("config.tes.inWorldHud.icons").define("inWorldHudEntityIcons", false);
        this.inWorldHudPotionIcons = config.comment("Whether the in-world entity status HUD should render the entity's effects icons").translation("config.tes.inWorldHud.potionIcons").define("inWorldHudPotionIcons", false);
        this.inWorldHudNameOverride = config.comment("Whether the in-world TES entity status HUD should override vanilla name rendering").translation("config.tes.inWorldHud.nameOverride").define("inWorldHudNameOverride", true);
        this.inWorldHudManualVerticalOffset = config.comment("Set a manual vertical offset for the TES in-world HUD (in blocks) in the event of other mods doing overhead rendering").translation("config.tes.inWorldHud.manualVerticalOffset").defineInRange("inWorldHudManualVerticalOffset", 0.0, (double)1.4E-45f, 3.4028234663852886E38);
        config.pop();
        config.push("Particle Settings");
        this.particlesEnabled = config.comment("Whether TES should do particles for various status changes such as damage dealt or health healed").translation("config.tes.particle.enabled").define("tesParticlesEnabled", true);
        this.particleDecimalPoints = config.comment(new String[]{"How many decimals the numeric TES Particles should round to", "Or set to 0 to only use whole-numbers"}).translation("config.tes.particle.decimalPoints").defineInRange("particleDecimalPoints", 1, 0, 8);
        this.particleScale = config.comment("Scale modifier for TES-Particles. The higher the value, the larger the particles").translation("config.tes.particle.scale").defineInRange("particleScale", 1.0, 0.0, 10.0);
        this.verbalHealthParticles = config.comment("Whether TES should do verbal health-status particles (E.G. INSTAKILL) in certain situations").translation("config.tes.particle.verbal").define("verbalHealthParticles", true);
        this.damageParticleColour = config.comment("What colour the damage-type particles should be. Value can be a packed int, byte, or hex value. Format is ARGB").translation("config.tes.particle.damageParticleColour").defineInRange("damageParticleColour", -65536, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.healParticleColour = config.comment("What colour the healing-type particles should be. Value can be a packed int, byte, or hex value. Format is ARGB").translation("config.tes.particle.healParticleColour").defineInRange("healParticleColour", -16711936, Integer.MIN_VALUE, Integer.MAX_VALUE);
        config.pop();
    }

    public double getEntityTrackingDistance() {
        return (Double)this.entityTrackingDistance.get();
    }

    public int getCacheCleanFrequency() {
        return (Integer)this.cacheCleanFrequency.get();
    }

    public boolean hudEnabled() {
        return (Boolean)this.hudEnabled.get();
    }

    public double getHudTargetDistance() {
        return (Double)this.hudTargetDistance.get();
    }

    public int hudTargetGracePeriod() {
        return (Integer)this.hudTargetGracePeriod.get();
    }

    public boolean hudEntityRender() {
        return (Boolean)this.hudEntityRender.get();
    }

    public boolean hudEntityDamageOverlay() {
        return (Boolean)this.hudEntityDamageTint.get();
    }

    public boolean hudEntityName() {
        return (Boolean)this.hudEntityName.get();
    }

    public boolean hudBossesEnabled() {
        return (Boolean)this.hudBossesEnabled.get();
    }

    public boolean hudArmour() {
        return (Boolean)this.hudArmour.get();
    }

    public boolean hudEntityIcons() {
        return (Boolean)this.hudEntityIcons.get();
    }

    public boolean hudPotionIcons() {
        return (Boolean)this.hudPotionIcons.get();
    }

    public float hudOpacity() {
        return ((Double)this.hudOpacity.get()).floatValue();
    }

    public float hudBarFontBackingOpacity() {
        return ((Double)this.hudBarFontBackingOpacity.get()).floatValue();
    }

    public TESHud.BarRenderType hudHealthRenderType() {
        return (TESHud.BarRenderType)((Object)this.hudHealthRenderType.get());
    }

    public boolean hudHealthBarSegments() {
        return (Boolean)this.hudHealthBarSegments.get();
    }

    public int hudHealthBarLength() {
        return (Integer)this.hudHealthBarLength.get();
    }

    public boolean inWorldBarsEnabled() {
        return (Boolean)this.inWorldBarsEnabled.get();
    }

    public boolean inWorldHudForSelf() {
        return (Boolean)this.inWorldHudForSelf.get();
    }

    public TESHUDActivation inWorldHUDActivation() {
        return (TESHUDActivation)((Object)this.inWorldHUDActivation.get());
    }

    public float inWorldHudOpacity() {
        return ((Double)this.inWorldHudOpacity.get()).floatValue();
    }

    public TESHud.BarRenderType inWorldBarsRenderType() {
        return (TESHud.BarRenderType)((Object)this.inWorldBarsRenderType.get());
    }

    public int inWorldBarsLength() {
        return (Integer)this.inWorldBarsLength.get();
    }

    public boolean inWorldBarsSegments() {
        return (Boolean)this.inWorldBarsSegments.get();
    }

    public boolean inWorldHudEntityName() {
        return (Boolean)this.inWorldHudEntityName.get();
    }

    public boolean inWorldHudArmour() {
        return (Boolean)this.inWorldHudArmour.get();
    }

    public boolean inWorldHudEntityIcons() {
        return (Boolean)this.inWorldHudEntityIcons.get();
    }

    public boolean inWorldHudPotionIcons() {
        return (Boolean)this.inWorldHudPotionIcons.get();
    }

    public boolean inWorldHudNameOverride() {
        return (Boolean)this.inWorldHudNameOverride.get();
    }

    public float inWorldHudManualVerticalOffset() {
        return ((Double)this.inWorldHudManualVerticalOffset.get()).floatValue();
    }

    public boolean particlesEnabled() {
        return (Boolean)this.particlesEnabled.get();
    }

    public int particleDecimalPoints() {
        return (Integer)this.particleDecimalPoints.get();
    }

    public float getParticleScale() {
        return ((Double)this.particleScale.get()).floatValue();
    }

    public boolean verbalHealthParticles() {
        return (Boolean)this.verbalHealthParticles.get();
    }

    public int getDamageParticleColour() {
        return (Integer)this.damageParticleColour.get();
    }

    public int getHealParticleColour() {
        return (Integer)this.healParticleColour.get();
    }

    public static void init() {
        Pair configSpec = new ForgeConfigSpec.Builder().configure(TESConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)configSpec.getRight());
        TESConstants.setConfig((TESConfig)configSpec.getLeft());
    }
}

