/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESEntityType;
import net.tslat.tes.api.TESHudElement;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.element.BuiltinHudElements;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public class TESHud {
    private static final Map<String, TESHudElement> ELEMENTS = (Map)Util.func_200696_a(Collections.synchronizedMap(new Object2ObjectArrayMap()), map -> {
        map.put("EntityName", BuiltinHudElements::renderEntityName);
        map.put("HealthBar", BuiltinHudElements::renderEntityHealth);
        map.put("Armour", BuiltinHudElements::renderEntityArmour);
        map.put("Icons", BuiltinHudElements::renderEntityIcons);
        map.put("Effects", BuiltinHudElements::renderEntityEffects);
    });
    private static TESHudElement[] INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
    private static LivingEntity TARGET_ENTITY = null;
    private static long TARGET_EXPIRY_TIME = -1L;

    public static void setTargetEntity(LivingEntity entity) {
        TARGET_ENTITY = entity;
        TARGET_EXPIRY_TIME = Minecraft.func_71410_x().field_71441_e.func_82737_E() + 1L + (long)TESAPI.getConfig().hudTargetGracePeriod();
    }

    public static LivingEntity getTargetEntity() {
        return TARGET_ENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHudElement(String name, TESHudElement element) {
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            ELEMENTS.put(name, element);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeHudElement(String name) {
        AtomicBoolean removed = new AtomicBoolean(false);
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            removed.set(ELEMENTS.remove(name) != null);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
        return removed.get();
    }

    public static void renderForHud(MatrixStack poseStack, Minecraft mc, float partialTick) {
        block8: {
            block7: {
                if (TARGET_ENTITY == null) {
                    return;
                }
                if (!TARGET_ENTITY.func_70089_S() || TESHud.TARGET_ENTITY.field_70170_p != mc.field_71441_e || mc.field_71441_e.func_82737_E() > TARGET_EXPIRY_TIME) {
                    TARGET_ENTITY = null;
                    return;
                }
                if (!TESAPI.getConfig().hudEnabled()) break block7;
                if (TESAPI.getConfig().hudBossesEnabled()) break block8;
                if (TESUtil.getEntityType(TARGET_ENTITY) != TESEntityType.BOSS) break block8;
            }
            return;
        }
        float hudOpacity = TESAPI.getConfig().hudOpacity();
        poseStack.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
        if (TESAPI.getConfig().hudEntityRender()) {
            TESClientUtil.renderEntityIcon(poseStack, mc, partialTick, TARGET_ENTITY, hudOpacity, true);
            poseStack.func_227861_a_(40.0, 0.0, 0.0);
        }
        poseStack.func_227861_a_(0.0, 2.0, 0.0);
        for (TESHudElement element : ELEMENTS.values()) {
            int offset = element.render(poseStack, mc, partialTick, TARGET_ENTITY, hudOpacity, false);
            if (offset <= 0) continue;
            poseStack.func_227861_a_(0.0, (double)(2 + offset), 0.0);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.func_227865_b_();
    }

    public static void renderInWorld(MatrixStack poseStack, LivingEntity entity, float partialTick) {
        if (!TESAPI.getConfig().inWorldBarsEnabled() || entity.func_233643_dh_() || entity == Minecraft.func_71410_x().field_71439_g && !TESAPI.getConfig().inWorldHudForSelf()) {
            return;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || !TESAPI.getConfig().inWorldHUDActivation().test(entityState)) {
            return;
        }
        float hudOpacity = TESAPI.getConfig().inWorldHudOpacity();
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d position = entity.func_242282_l(partialTick).func_178788_d(mc.field_71460_t.func_215316_n().func_216785_c()).func_178787_e(mc.func_175598_ae().func_78713_a((Entity)entity).func_225627_b_((Entity)entity, partialTick));
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        poseStack.func_227861_a_(0.0, (double)(entity.func_213302_cg() + 0.5f), 0.0);
        poseStack.func_227861_a_(0.0, (double)TESConstants.CONFIG.inWorldHudManualVerticalOffset(), 0.0);
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        poseStack.func_227862_a_(0.02f, 0.02f, 0.02f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
        for (TESHudElement element : INVERSE_ELEMENTS) {
            int offset = element.render(poseStack, mc, partialTick, entity, hudOpacity, true);
            if (offset <= 0) continue;
            poseStack.func_227861_a_(0.0, (double)(-(2 + offset)), 0.0);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.func_227865_b_();
    }

    public static void pickNewEntity(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_147125_j != null) {
            LivingEntity target = TESUtil.getLivingEntityIfPossible(mc.field_147125_j);
            if (TESUtil.isVisibleToPlayer(target, TESClientUtil.getClientPlayer())) {
                TESHud.setTargetEntity(target);
            }
        } else {
            AxisAlignedBB hitBounds;
            Vector3d cameraView;
            Vector3d rayEnd;
            Vector3d cameraPos;
            double targetingRange = TESAPI.getConfig().getHudTargetDistance();
            Entity cameraEntity = mc.func_175606_aa();
            EntityRayTraceResult hitResult = ProjectileHelper.func_221273_a((Entity)cameraEntity, (Vector3d)(cameraPos = cameraEntity.func_174824_e(partialTick)), (Vector3d)(rayEnd = cameraPos.func_178787_e((cameraView = cameraEntity.func_70676_i(partialTick)).func_216372_d(targetingRange, targetingRange, targetingRange))), (AxisAlignedBB)(hitBounds = cameraEntity.func_174813_aQ().func_216361_a(cameraView.func_186678_a(targetingRange)).func_72314_b(1.0, 1.0, 1.0)), entity -> !entity.func_175149_v() && entity.func_70067_L(), (double)(targetingRange * targetingRange));
            if (hitResult == null) {
                return;
            }
            LivingEntity target = TESUtil.getLivingEntityIfPossible(hitResult.func_216348_a());
            if (!TESUtil.isVisibleToPlayer(target, TESClientUtil.getClientPlayer())) {
                return;
            }
            double entityHitClipDistanceSqr = hitResult.func_216347_e().func_72436_e(cameraPos);
            targetingRange = Math.sqrt(entityHitClipDistanceSqr);
            rayEnd = cameraPos.func_178787_e(cameraView.func_216372_d(targetingRange, targetingRange, targetingRange));
            BlockRayTraceResult blockHitResult = cameraEntity.field_70170_p.func_217299_a(new RayTraceContext(cameraPos, rayEnd, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, cameraEntity));
            if (blockHitResult == null || blockHitResult.func_216346_c() == RayTraceResult.Type.MISS || blockHitResult.func_216347_e().func_72436_e(cameraPos) > entityHitClipDistanceSqr) {
                TESHud.setTargetEntity(target);
            }
        }
    }

    private static TESHudElement[] buildInverseElementArray(Collection<TESHudElement> elements) {
        TESHudElement[] array = new TESHudElement[elements.size()];
        int i = elements.size() - 1;
        for (TESHudElement element : elements) {
            array[i--] = element;
        }
        return array;
    }

    public static enum BarRenderType {
        NUMERIC,
        BAR,
        COMBINED;

    }
}

