/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.config.TESConfig;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public final class BuiltinHudElements {
    private static final ResourceLocation BARS_TEXTURE = new ResourceLocation("textures/gui/bars.png");
    private static final ResourceLocation ICONS_TEXTURE = new ResourceLocation("tslatentitystatus", "textures/gui/tes_icons.png");

    public static int renderEntityName(MatrixStack poseStack, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud) {
            if (!(TESAPI.getConfig().inWorldHudEntityName() || TESConstants.CONFIG.inWorldHudNameOverride() && entity.func_145818_k_())) {
                return 0;
            }
            TESClientUtil.renderCenteredText(entity.func_145748_c_(), poseStack, mc.field_71466_p, 0.0f, 0.0f, TESClientUtil.packColour((int)(opacity * 255.0f), 255, 255, 255));
        } else {
            if (!TESAPI.getConfig().hudEntityName()) {
                return 0;
            }
            TESClientUtil.drawTextWithShadow(poseStack, entity.func_145748_c_(), 0.0f, 0.0f, TESClientUtil.packColour((int)(opacity * 255.0f), 255, 255, 255));
        }
        TESEntityTracking.markNameRendered(entity);
        mc.field_71466_p.getClass();
        return 9;
    }

    public static int renderEntityHealth(MatrixStack poseStack, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null) {
            return 0;
        }
        TESConfig config = TESAPI.getConfig();
        int barWidth = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        int uvY = TESUtil.getEntityType(entity).getTextureYPos();
        float percentTransitionHealth = entityState.getLastTransitionHealth() / entity.func_110138_aP();
        float percentHealth = entityState.getHealth() / entity.func_110138_aP();
        TESHud.BarRenderType renderType = inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType();
        boolean doSegments = inWorldHud ? config.inWorldBarsSegments() : config.hudHealthBarSegments();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, inWorldHud ? 4.0 : 1.0, 0.0);
        if (inWorldHud) {
            poseStack.func_227861_a_((double)((float)barWidth * -0.5f), 0.0, 0.0);
        }
        TESClientUtil.prepRenderForTexture(BARS_TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        if (renderType != TESHud.BarRenderType.NUMERIC) {
            TESClientUtil.constructBarRender(poseStack, 0, 0, barWidth, 60, 1.0f, false, opacity);
            poseStack.func_227861_a_(0.0, 0.0, (double)-0.001f);
            if (percentTransitionHealth > percentHealth) {
                TESClientUtil.constructBarRender(poseStack, 0, 0, barWidth, uvY, entityState.getLastTransitionHealth() / entity.func_110138_aP(), false, opacity);
            }
            poseStack.func_227861_a_(0.0, 0.0, (double)-0.001f);
            RenderSystem.enableBlend();
            TESClientUtil.constructBarRender(poseStack, 0, 0, barWidth, uvY + 5, percentHealth, doSegments, opacity);
        }
        if (renderType != TESHud.BarRenderType.BAR) {
            String healthText = TESUtil.roundToDecimal(entityState.getHealth(), 1) + "/" + TESUtil.roundToDecimal(entity.func_110138_aP(), 1);
            float halfTextWidth = (float)mc.field_71466_p.func_78256_a(healthText) / 2.0f;
            float center = (float)barWidth / 2.0f;
            poseStack.func_227861_a_(0.0, 0.0, (double)-0.001f);
            TESClientUtil.drawColouredSquare(poseStack, (int)(center - halfTextWidth - 1.0f), -2, (int)(halfTextWidth * 2.0f) + 1, 9, 0x90909 | (int)(opacity * 255.0f * TESConstants.CONFIG.hudBarFontBackingOpacity()) << 24);
            poseStack.func_227861_a_(0.0, 0.0, (double)-0.001f);
            TESClientUtil.drawText(poseStack, healthText, center - halfTextWidth, -1.0f, TESClientUtil.packColour((int)(opacity * 255.0f), 255, 255, 255));
        }
        poseStack.func_227865_b_();
        mc.field_71466_p.getClass();
        return 9;
    }

    public static int renderEntityArmour(MatrixStack poseStack, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudArmour() : !TESAPI.getConfig().hudArmour()) {
            return 0;
        }
        int armour = TESUtil.getArmour(entity);
        if (armour <= 0) {
            return 0;
        }
        poseStack.func_227860_a_();
        float toughness = TESUtil.getArmourToughness(entity);
        int textColour = TESClientUtil.packColour((int)(opacity * 255.0f), 255, 255, 255);
        if (inWorldHud) {
            int totalWidth = toughness > 0.0f ? 43 + mc.field_71466_p.func_78256_a("x" + TESUtil.roundToDecimal(toughness, 1)) : mc.field_71466_p.func_78256_a("x" + armour) + 10;
            poseStack.func_227861_a_((double)((float)totalWidth * -0.5f), 0.0, 0.0);
        }
        TESClientUtil.prepRenderForTexture(Screen.field_230665_h_);
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        TESClientUtil.drawSimpleTexture(poseStack, 0, 0, 9, 9, 34.0f, 9.0f, 256);
        if (toughness > 0.0f) {
            TESClientUtil.drawSimpleTexture(poseStack, 33, 0, 9, 9, 43.0f, 18.0f, 256);
        }
        TESClientUtil.drawText(poseStack, "x" + armour, 9.5f, 1.0f, textColour);
        if (toughness > 0.0f) {
            TESClientUtil.drawText(poseStack, "x" + TESUtil.roundToDecimal(toughness, 1), 43.0f, 1.0f, textColour);
        }
        poseStack.func_227865_b_();
        mc.field_71466_p.getClass();
        return 9;
    }

    public static int renderEntityIcons(MatrixStack poseStack, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        CreatureAttribute mobType;
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudEntityIcons() : !TESAPI.getConfig().hudEntityIcons()) {
            return 0;
        }
        int x = 0;
        TESClientUtil.prepRenderForTexture(ICONS_TEXTURE);
        if (TESUtil.isFireImmune((Entity)entity)) {
            TESClientUtil.drawSimpleTexture(poseStack, x, 0, 8, 8, 0.0f, 0.0f, 32);
            x += 9;
        }
        if (TESUtil.isMeleeMob(entity)) {
            TESClientUtil.drawSimpleTexture(poseStack, x, 0, 8, 8, 8.0f, 0.0f, 32);
            x += 9;
        }
        if (TESUtil.isRangedMob(entity)) {
            TESClientUtil.drawSimpleTexture(poseStack, x, 0, 8, 8, 16.0f, 0.0f, 32);
            x += 9;
        }
        if ((mobType = entity.func_70668_bt()) != CreatureAttribute.field_223222_a_) {
            int mobTypeU = mobType == CreatureAttribute.field_203100_e ? 24 : (mobType == CreatureAttribute.field_223225_d_ ? 16 : (mobType == CreatureAttribute.field_223224_c_ ? 8 : 0));
            TESClientUtil.drawSimpleTexture(poseStack, x, 0, 8, 8, mobTypeU, 8.0f, 32);
            x += 9;
        }
        return x == 0 ? 0 : 8;
    }

    public static int renderEntityEffects(MatrixStack poseStack, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudPotionIcons() : !TESAPI.getConfig().hudPotionIcons()) {
            return 0;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || entityState.getEffects().isEmpty()) {
            return 0;
        }
        int effectsSize = entityState.getEffects().size();
        PotionSpriteUploader textureManager = mc.func_213248_ap();
        int barLength = inWorldHud ? TESAPI.getConfig().inWorldBarsLength() : TESAPI.getConfig().hudHealthBarLength();
        float maxX = (float)barLength * 2.0f;
        int iconsPerRow = (int)Math.floor(maxX / 18.0f);
        int rows = (int)Math.ceil((float)effectsSize / (float)iconsPerRow);
        int x = inWorldHud ? Math.min(effectsSize, iconsPerRow) * -9 : 0;
        int y = 0;
        int i = 0;
        poseStack.func_227860_a_();
        poseStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        if (inWorldHud) {
            poseStack.func_227861_a_(0.0, Math.floor((float)(effectsSize * 18) / maxX) * -18.0, 0.0);
        }
        for (ResourceLocation effectId : entityState.getEffects()) {
            TextureAtlasSprite sprite = textureManager.func_215288_a((Effect)Registry.field_212631_t.func_82594_a(effectId));
            TESClientUtil.prepRenderForTexture(sprite.func_229241_m_().func_229223_g_());
            Screen.func_238470_a_((MatrixStack)poseStack, (int)(i * 18 + x), (int)y, (int)0, (int)18, (int)18, (TextureAtlasSprite)sprite);
            if (++i < iconsPerRow) continue;
            i = 0;
            if (!inWorldHud || (y += 18) / 18 != rows - 1) continue;
            x = effectsSize % iconsPerRow % iconsPerRow * -9;
        }
        poseStack.func_227865_b_();
        return (int)Math.ceil((float)effectsSize / (float)iconsPerRow) * 9;
    }
}

