/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleClaimant;
import net.tslat.tes.core.state.EntityState;

public final class TESParticleManager {
    private static final ConcurrentLinkedQueue<TESParticle<?>> PARTICLES = new ConcurrentLinkedQueue();
    private static final Object2ObjectOpenHashMap<ResourceLocation, TESParticleClaimant> CLAIMANTS = new Object2ObjectOpenHashMap();
    private static final ConcurrentMap<Integer, List<Pair<ResourceLocation, CompoundNBT>>> CLAIMS = new ConcurrentHashMap<Integer, List<Pair<ResourceLocation, CompoundNBT>>>();
    private static final ObjectArrayList<Runnable> NEW_CLAIMS = new ObjectArrayList();

    public static void addParticle(TESParticle<?> particle) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        PARTICLES.add(particle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParticleClaimant(ResourceLocation id, TESParticleClaimant claimant) {
        Object2ObjectOpenHashMap<ResourceLocation, TESParticleClaimant> object2ObjectOpenHashMap = CLAIMANTS;
        synchronized (object2ObjectOpenHashMap) {
            CLAIMANTS.put((Object)id, (Object)claimant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParticleClaim(int entityId, ResourceLocation claimantId, @Nullable CompoundNBT data) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        ObjectArrayList<Runnable> objectArrayList = NEW_CLAIMS;
        synchronized (objectArrayList) {
            NEW_CLAIMS.add(() -> CLAIMS.computeIfAbsent(entityId, key -> new ObjectArrayList()).add(Pair.of((Object)claimantId, (Object)data)));
        }
    }

    public static float handleParticleClaims(EntityState entityState, float healthDelta, Consumer<TESParticle<?>> particleAdder) {
        Pair pair;
        Iterator iterator = CLAIMS.getOrDefault(entityState.getEntity().func_145782_y(), Collections.emptyList()).iterator();
        while (iterator.hasNext() && (healthDelta = ((TESParticleClaimant)CLAIMANTS.getOrDefault((pair = (Pair)iterator.next()).getFirst(), (state, delta, data, adder) -> delta)).checkClaim(entityState, healthDelta, (CompoundNBT)pair.getSecond(), particleAdder)) != 0.0f) {
        }
        return healthDelta;
    }

    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!TESAPI.getConfig().particlesEnabled()) {
            PARTICLES.clear();
            CLAIMS.clear();
            return;
        }
        if (!mc.func_147113_T()) {
            PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.tick(mc)));
            PARTICLES.removeIf(particle -> !particle.isValid());
        }
    }

    public static void clearClaims() {
        CLAIMS.clear();
        NEW_CLAIMS.forEach(Runnable::run);
        NEW_CLAIMS.clear();
    }

    public static void render(MatrixStack poseStack, float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.render(poseStack, mc, fontRenderer, partialTick)));
    }
}

