/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.DamageParticle;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.particle.type.HealParticle;
import net.tslat.tes.networking.TESNetworking;

public class EntityState {
    protected final LivingEntity entity;
    protected Set<ResourceLocation> effects;
    protected float currentHealth;
    protected float lastHealth;
    protected float lastTransitionHealth;
    protected long lastTransitionTime;

    public EntityState(LivingEntity entity) {
        this.entity = entity;
        this.lastHealth = this.currentHealth = entity.func_110143_aJ();
        TESNetworking.requestEffectsSync(this.entity.func_145782_y());
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public float getHealth() {
        return this.currentHealth;
    }

    public float getLastHealth() {
        return this.lastHealth;
    }

    public float getLastTransitionHealth() {
        return this.lastTransitionHealth;
    }

    public float getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public Set<ResourceLocation> getEffects() {
        return this.effects == null ? Collections.emptySet() : this.effects;
    }

    public void modifyEffects(Set<ResourceLocation> ids, Set<ResourceLocation> idsToRemove) {
        if (this.effects == null) {
            this.effects = new ObjectOpenHashSet(ids);
        } else {
            this.effects.addAll(ids);
        }
        this.effects.removeAll(idsToRemove);
    }

    public boolean isValid() {
        return this.entity != null && this.entity.func_70089_S() && this.entity.field_70170_p == Minecraft.func_71410_x().field_71441_e;
    }

    public void tick() {
        this.currentHealth = Math.min(this.entity.func_110143_aJ(), this.entity.func_110138_aP());
        if (this.currentHealth != this.lastHealth) {
            this.handleHealthChange();
        }
        this.lastHealth = this.currentHealth;
        if (this.entity.field_70170_p.func_82737_E() - this.lastTransitionTime > 20L) {
            if (this.lastTransitionHealth > this.currentHealth) {
                this.lastTransitionHealth -= this.entity.func_110138_aP() / 30.0f;
            } else {
                this.lastTransitionTime = 0L;
                this.lastTransitionHealth = this.currentHealth;
            }
        }
    }

    protected void handleHealthChange() {
        if (TESAPI.getConfig().particlesEnabled()) {
            GenericTESParticle particle;
            float healthDelta = this.currentHealth - this.lastHealth;
            if (healthDelta != 0.0f) {
                healthDelta = TESParticleManager.handleParticleClaims(this, healthDelta, TESParticleManager::addParticle);
            }
            if (healthDelta == 0.0f) {
                return;
            }
            Vector3f particlePos = new Vector3f((float)this.entity.func_226277_ct_(), (float)this.entity.func_226280_cw_() + 0.5f, (float)this.entity.func_226281_cx_());
            if (healthDelta < 0.0f) {
                this.lastTransitionTime = this.entity.field_70170_p.func_82737_E();
                if (this.lastTransitionHealth == 0.0f) {
                    this.lastTransitionHealth = this.lastHealth;
                }
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth <= 0.0f && this.lastHealth >= this.entity.func_110138_aP() ? new ComponentParticle(this, particlePos, TESParticle.Animation.POP_OFF, (ITextComponent)new TranslationTextComponent("config.tes.particle.verbal.instakill").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TESAPI.getConfig().getDamageParticleColour())))) : new DamageParticle(this, particlePos, healthDelta * -1.0f);
            } else {
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth >= this.entity.func_110138_aP() && this.lastHealth <= this.entity.func_110138_aP() * 0.05f ? new ComponentParticle(this, particlePos, TESParticle.Animation.RISE, (ITextComponent)new TranslationTextComponent("config.tes.particle.verbal.fullHeal").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)TESAPI.getConfig().getHealParticleColour())))) : new HealParticle(this, particlePos, healthDelta);
            }
            TESParticleManager.addParticle(particle);
        }
    }
}

