/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.state.EntityState;

public class NewComponentParticlePacket {
    private final int entityId;
    private final ITextComponent contents;
    private final Vector3f position;

    private NewComponentParticlePacket(int entityId, ITextComponent contents, Vector3f position) {
        this.entityId = entityId;
        this.contents = contents;
        this.position = position;
    }

    public NewComponentParticlePacket(LivingEntity entity, ITextComponent contents) {
        this.entityId = entity.func_145782_y();
        this.contents = contents;
        this.position = new Vector3f((float)entity.func_226277_ct_(), (float)entity.func_226280_cw_(), (float)entity.func_226281_cx_());
    }

    public NewComponentParticlePacket(Vector3f position, ITextComponent contents) {
        this.entityId = -1;
        this.contents = contents;
        this.position = position;
    }

    public void encode(PacketBuffer buf) {
        buf.writeFloat(this.position.func_195899_a());
        buf.writeFloat(this.position.func_195900_b());
        buf.writeFloat(this.position.func_195902_c());
        buf.func_179256_a(this.contents);
        buf.func_150787_b(this.entityId);
    }

    public static NewComponentParticlePacket decode(PacketBuffer buf) {
        Vector3f position = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
        ITextComponent contents = buf.func_179258_d();
        int entityId = buf.func_150792_a();
        return entityId == -1 ? new NewComponentParticlePacket(position, contents) : new NewComponentParticlePacket(entityId, contents, position);
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (this.entityId == -1) {
                TESParticleManager.addParticle(new ComponentParticle(null, this.position, this.contents));
            } else {
                EntityState entityState = TESAPI.getTESDataForEntity(this.entityId);
                if (entityState != null) {
                    TESParticleManager.addParticle(new ComponentParticle(entityState, this.position, this.contents));
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

