/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.NumericParticle;

public class NewNumericParticlePacket {
    private final double value;
    private final Vector3f position;
    private final int colour;

    public NewNumericParticlePacket(double value, Vector3f position, int colour) {
        this.value = value;
        this.position = position;
        this.colour = colour;
    }

    public void encode(PacketBuffer buf) {
        buf.writeDouble(this.value);
        buf.writeFloat(this.position.func_195899_a());
        buf.writeFloat(this.position.func_195900_b());
        buf.writeFloat(this.position.func_195902_c());
        buf.func_150787_b(this.colour);
    }

    public static NewNumericParticlePacket decode(PacketBuffer buf) {
        return new NewNumericParticlePacket(buf.readDouble(), new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()), buf.func_150792_a());
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> TESParticleManager.addParticle(new NumericParticle(null, this.position, this.value).withColour(this.colour)));
        context.get().setPacketHandled(true);
    }
}

