/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.tes.core.particle.TESParticleManager;

public class ParticleClaimPacket {
    private final int entityId;
    private final ResourceLocation claimantId;
    @Nullable
    private final CompoundNBT data;

    public ParticleClaimPacket(int entityId, ResourceLocation claimantId, @Nullable CompoundNBT data) {
        this.entityId = entityId;
        this.claimantId = claimantId;
        this.data = data;
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
        buf.func_192572_a(this.claimantId);
        buf.func_150786_a(this.data);
    }

    public static ParticleClaimPacket decode(PacketBuffer buf) {
        return new ParticleClaimPacket(buf.func_150792_a(), buf.func_192575_l(), buf.func_150793_b());
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> TESParticleManager.addParticleClaim(this.entityId, this.claimantId, this.data));
        context.get().setPacketHandled(true);
    }
}

