/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tslat.tes.networking.TESNetworking;

public class RequestEffectsPacket {
    private final int entityId;

    public RequestEffectsPacket(int entityId) {
        this.entityId = entityId;
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
    }

    public static RequestEffectsPacket decode(PacketBuffer buf) {
        return new RequestEffectsPacket(buf.func_150792_a());
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)context.get()).getSender().func_71121_q().func_73045_a(this.entityId);
            if (entity instanceof LivingEntity) {
                Collection effects = ((LivingEntity)entity).func_70651_bq();
                ObjectOpenHashSet ids = new ObjectOpenHashSet(effects.size());
                for (EffectInstance instance : effects) {
                    if (!instance.func_188418_e() && !instance.func_205348_f()) continue;
                    ids.add(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)instance.func_188419_a()));
                }
                TESNetworking.sendEffectsSync(((NetworkEvent.Context)context.get()).getSender(), this.entityId, (Set<ResourceLocation>)ids, Collections.emptySet());
            }
        });
        context.get().setPacketHandled(true);
    }
}

