/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public class SyncEffectsPacket {
    private final int entityId;
    private final Set<ResourceLocation> idsToAdd;
    private final Set<ResourceLocation> idsToRemove;

    public SyncEffectsPacket(int entityId, Set<ResourceLocation> idsToAdd, Set<ResourceLocation> idsToRemove) {
        this.entityId = entityId;
        this.idsToAdd = idsToAdd;
        this.idsToRemove = idsToRemove;
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.entityId);
        SyncEffectsPacket.writeCollection(buf, this.idsToAdd, PacketBuffer::func_192572_a);
        SyncEffectsPacket.writeCollection(buf, this.idsToRemove, PacketBuffer::func_192572_a);
    }

    public static SyncEffectsPacket decode(PacketBuffer buf) {
        return new SyncEffectsPacket(buf.func_150792_a(), (Set)SyncEffectsPacket.readCollection(buf, ObjectOpenHashSet::new, PacketBuffer::func_192575_l), (Set)SyncEffectsPacket.readCollection(buf, ObjectOpenHashSet::new, PacketBuffer::func_192575_l));
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            EntityState state = TESEntityTracking.getStateForEntityId(this.entityId);
            if (state != null) {
                state.modifyEffects(this.idsToAdd, this.idsToRemove);
            }
        });
        context.get().setPacketHandled(true);
    }

    private static <E, T extends Collection<E>> T readCollection(PacketBuffer buffer, Int2ObjectFunction<T> collection, Function<PacketBuffer, E> elementFunction) {
        int size = buffer.func_150792_a();
        Collection coll = (Collection)collection.apply(size);
        for (int i = 0; i < size; ++i) {
            coll.add(elementFunction.apply(buffer));
        }
        return (T)coll;
    }

    private static <E, T extends Collection<E>> void writeCollection(PacketBuffer buffer, T collection, BiConsumer<PacketBuffer, E> elementFunction) {
        buffer.func_150787_b(collection.size());
        for (E element : collection) {
            elementFunction.accept(buffer, element);
        }
    }
}

