/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.networking.NewComponentParticlePacket;
import net.tslat.tes.networking.NewNumericParticlePacket;
import net.tslat.tes.networking.ParticleClaimPacket;
import net.tslat.tes.networking.RequestEffectsPacket;
import net.tslat.tes.networking.SyncEffectsPacket;

public final class TESNetworking {
    private static final String REV = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tslatentitystatus", "tes_packets"), () -> "1", rev -> {
        if (rev.equals(NetworkRegistry.ABSENT)) {
            EFFECTS_SYNCING_ENABLED = false;
            return true;
        }
        if (rev.equals(REV)) {
            EFFECTS_SYNCING_ENABLED = TESAPI.getConfig().hudPotionIcons() || TESAPI.getConfig().inWorldHudPotionIcons();
            return true;
        }
        return false;
    }, rev -> {
        if (rev.equals(NetworkRegistry.ABSENT)) {
            EFFECTS_SYNCING_ENABLED = false;
            return true;
        }
        if (rev.equals(REV)) {
            EFFECTS_SYNCING_ENABLED = TESAPI.getConfig().hudPotionIcons() || TESAPI.getConfig().inWorldHudPotionIcons();
            return true;
        }
        return false;
    });
    private static boolean EFFECTS_SYNCING_ENABLED = true;

    public static void init() {
        int id = 0;
        INSTANCE.registerMessage(id++, RequestEffectsPacket.class, RequestEffectsPacket::encode, RequestEffectsPacket::decode, RequestEffectsPacket::handleMessage);
        INSTANCE.registerMessage(id++, SyncEffectsPacket.class, SyncEffectsPacket::encode, SyncEffectsPacket::decode, SyncEffectsPacket::handleMessage);
        INSTANCE.registerMessage(id++, ParticleClaimPacket.class, ParticleClaimPacket::encode, ParticleClaimPacket::decode, ParticleClaimPacket::handleMessage);
        INSTANCE.registerMessage(id++, NewComponentParticlePacket.class, NewComponentParticlePacket::encode, NewComponentParticlePacket::decode, NewComponentParticlePacket::handleMessage);
        INSTANCE.registerMessage(id++, NewNumericParticlePacket.class, NewNumericParticlePacket::encode, NewNumericParticlePacket::decode, NewNumericParticlePacket::handleMessage);
    }

    public static boolean isSyncingEffects() {
        return EFFECTS_SYNCING_ENABLED;
    }

    public static void requestEffectsSync(int entityId) {
        if (!TESNetworking.isSyncingEffects()) {
            return;
        }
        INSTANCE.sendToServer((Object)new RequestEffectsPacket(entityId));
    }

    public static void sendEffectsSync(ServerPlayerEntity player, int entityId, Set<ResourceLocation> toAdd, Set<ResourceLocation> toRemove) {
        if (!TESNetworking.isSyncingEffects()) {
            return;
        }
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncEffectsPacket(entityId, toAdd, toRemove));
    }

    public static void sendEffectsSync(LivingEntity targetedEntity, Set<ResourceLocation> toAdd, Set<ResourceLocation> toRemove) {
        if (!TESNetworking.isSyncingEffects()) {
            return;
        }
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new SyncEffectsPacket(targetedEntity.func_145782_y(), toAdd, toRemove));
    }

    public static void sendParticle(World level, Vector3f position, ITextComponent contents) {
        INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)position.func_195899_a(), (double)position.func_195900_b(), (double)position.func_195902_c(), (double)200.0, (RegistryKey)level.func_234923_W_())), (Object)new NewComponentParticlePacket(position, contents));
    }

    public static void sendParticle(LivingEntity targetedEntity, ITextComponent contents) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new NewComponentParticlePacket(targetedEntity, contents));
    }

    public static void sendParticle(World level, Vector3f position, double value, int colour) {
        INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)position.func_195899_a(), (double)position.func_195900_b(), (double)position.func_195902_c(), (double)200.0, (RegistryKey)level.func_234923_W_())), (Object)new NewNumericParticlePacket(value, position, colour));
    }

    public static void sendParticle(LivingEntity targetedEntity, double value, int colour) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new NewNumericParticlePacket(value, new Vector3f((float)targetedEntity.func_226277_ct_(), (float)targetedEntity.func_226280_cw_(), (float)targetedEntity.func_226281_cx_()), colour));
    }

    public static void sendParticleClaim(ResourceLocation claimantId, LivingEntity targetedEntity, @Nullable CompoundNBT additionalData) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> targetedEntity), (Object)new ParticleClaimPacket(targetedEntity.func_145782_y(), claimantId, additionalData));
    }
}

