/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle.type;

import com.mojang.math.Vector3f;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.state.EntityState;

public abstract class GenericTESParticle<D>
implements TESParticle<D> {
    protected static final int DEFAULT_LIFESPAN = 10;
    protected int lifetime;
    protected final Vector3f pos;
    protected final Vector3f prevPos;
    protected final Vector3f velocity;
    protected final TESParticle.Animation animation;
    @Nullable
    protected final EntityState entityState;

    protected GenericTESParticle(@Nullable EntityState entityState, Vector3f position) {
        this(entityState, position, TESParticle.Animation.POP_OFF);
    }

    protected GenericTESParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation) {
        this(entityState, position, TESParticle.Animation.POP_OFF, 10);
    }

    protected GenericTESParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, int lifespan) {
        this.entityState = entityState;
        this.lifetime = lifespan;
        this.pos = position;
        this.prevPos = this.pos.m_122281_();
        this.animation = animation;
        this.velocity = animation.getInitialVelocity(this, position, ThreadLocalRandom.current());
    }

    @Override
    public void tick(Minecraft mc) {
        --this.lifetime;
        this.prevPos.m_122245_(this.pos.m_122239_(), this.pos.m_122260_(), this.pos.m_122269_());
        this.animation.perTickModifier(this, this.lifetime, this.pos, this.prevPos, this.velocity, ThreadLocalRandom.current());
    }

    @Override
    public boolean isValid() {
        return this.lifetime >= 0;
    }
}

