/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle.type;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.state.EntityState;

public class TextParticle
extends GenericTESParticle<String> {
    protected String text;
    protected int colour = -1;

    public TextParticle(@Nullable EntityState entityState, Vector3f position, String text) {
        this(entityState, position, TESParticle.Animation.POP_OFF, text);
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text) {
        this(entityState, position, animation, text, 10);
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text, int lifespan) {
        super(entityState, position, animation, lifespan);
        this.updateData(text);
    }

    public TextParticle withColour(int colour) {
        this.colour = colour;
        return this;
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void updateData(String data) {
        this.text = data;
    }

    @Override
    public void render(PoseStack poseStack, Minecraft mc, Font fontRenderer, float partialTick) {
        this.defaultedTextRender(mc, poseStack, this.prevPos, this.pos, partialTick, () -> TESClientUtil.renderCenteredText(this.text, poseStack, fontRenderer, 0.0f, 0.0f, this.getColour()));
    }
}

