/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.state.EntityState;

public final class TESEntityTracking {
    private static final Int2ObjectOpenHashMap<EntityState> ENTITY_STATES = new Int2ObjectOpenHashMap(50);
    private static List<LivingEntity> ENTITIES_TO_RENDER = new ObjectArrayList();
    private static IntSet RENDERED_NAMES = new IntOpenHashSet();

    public static void accountForEntity(LivingEntity entity) {
        ENTITY_STATES.compute(entity.m_142049_(), (key, value) -> {
            double trackingDist = TESAPI.getConfig().getEntityTrackingDistance();
            Object object = Minecraft.m_91087_().f_91075_ == null ? Minecraft.m_91087_().f_91074_ : Minecraft.m_91087_().f_91075_;
            if (entity.m_20280_((Entity)object) > trackingDist * trackingDist) {
                return null;
            }
            return value == null ? new EntityState(entity) : value;
        });
    }

    public static void tick() {
        TESParticleManager.clearClaims();
        ENTITY_STATES.values().forEach(EntityState::tick);
        if (Minecraft.m_91087_().f_91073_.m_46467_() % (long)TESAPI.getConfig().getCacheCleanFrequency() == 0L) {
            ENTITY_STATES.values().removeIf(state -> !state.isValid());
        }
    }

    public static void addEntityToRender(LivingEntity entity) {
        ENTITIES_TO_RENDER.add(entity);
    }

    @Nullable
    public static EntityState getStateForEntity(LivingEntity entity) {
        return TESEntityTracking.getStateForEntityId(entity.m_142049_());
    }

    @Nullable
    public static EntityState getStateForEntityId(int id) {
        return (EntityState)ENTITY_STATES.get(id);
    }

    public static List<LivingEntity> getEntitiesToRender() {
        List<LivingEntity> entities = ENTITIES_TO_RENDER;
        ENTITIES_TO_RENDER = new ObjectArrayList(ENTITIES_TO_RENDER.size());
        RENDERED_NAMES.clear();
        return entities;
    }

    public static boolean wasNameRendered(int entityId) {
        return RENDERED_NAMES.contains(entityId);
    }

    public static void markNameRendered(LivingEntity entity) {
        RENDERED_NAMES.add(entity.m_142049_());
    }
}

