/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public class SyncEffectsPacket {
    private final int entityId;
    private final Set<ResourceLocation> idsToAdd;
    private final Set<ResourceLocation> idsToRemove;

    public SyncEffectsPacket(int entityId, Set<ResourceLocation> idsToAdd, Set<ResourceLocation> idsToRemove) {
        this.entityId = entityId;
        this.idsToAdd = idsToAdd;
        this.idsToRemove = idsToRemove;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_178352_(this.idsToAdd, FriendlyByteBuf::m_130085_);
        buf.m_178352_(this.idsToRemove, FriendlyByteBuf::m_130085_);
    }

    public static SyncEffectsPacket decode(FriendlyByteBuf buf) {
        return new SyncEffectsPacket(buf.m_130242_(), (Set)buf.m_178371_(ObjectOpenHashSet::new, FriendlyByteBuf::m_130281_), (Set)buf.m_178371_(ObjectOpenHashSet::new, FriendlyByteBuf::m_130281_));
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            EntityState state = TESEntityTracking.getStateForEntityId(this.entityId);
            if (state != null) {
                state.modifyEffects(this.idsToAdd, this.idsToRemove);
            }
        });
        context.get().setPacketHandled(true);
    }
}

