/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.util.TESClientUtil;

public interface TESParticle<D> {
    public void updateData(D var1);

    public void render(PoseStack var1, Minecraft var2, Font var3, float var4);

    public void tick(Minecraft var1);

    public boolean isValid();

    default public void defaultedTextRender(Minecraft mc, PoseStack poseStack, Vector3f prevPos, Vector3f pos, float partialTick, Runnable renderCallback) {
        float scale = 0.035f * TESAPI.getConfig().getParticleScale();
        Camera camera = mc.f_91063_.m_109153_();
        Vector3f renderPos = prevPos.m_122281_();
        renderPos.m_122255_(pos, partialTick);
        renderPos.m_122267_(new Vector3f(camera.m_90583_()));
        poseStack.m_85836_();
        poseStack.m_85837_((double)renderPos.m_122239_(), (double)renderPos.m_122260_(), (double)renderPos.m_122269_());
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        renderCallback.run();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    public static abstract class Animation {
        public static final Animation POP_OFF = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                return new Vector3f((float)random.nextGaussian() * 0.03f + 0.025f, random.nextFloat() * 0.045f + 0.3f, (float)random.nextGaussian() * 0.03f + 0.025f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.m_122267_(new Vector3f(0.0f, 0.05f, 0.0f));
                pos.m_122253_(velocity);
            }
        };
        public static final Animation RISE = new Animation(){

            @Override
            public Vector3f getInitialVelocity(TESParticle<?> particle, Vector3f position, Random random) {
                position.m_122272_((float)random.nextGaussian() * 0.05f, 0.1f, (float)random.nextGaussian() * 0.05f);
                return new Vector3f(0.0f, 0.2f, 0.0f);
            }

            @Override
            public void perTickModifier(TESParticle<?> particle, int lifetime, Vector3f pos, Vector3f prevPos, Vector3f velocity, Random random) {
                velocity.m_122267_(new Vector3f(0.0f, 0.02f, 0.0f));
                pos.m_122253_(velocity);
            }
        };

        public abstract Vector3f getInitialVelocity(TESParticle<?> var1, Vector3f var2, Random var3);

        public abstract void perTickModifier(TESParticle<?> var1, int var2, Vector3f var3, Vector3f var4, Vector3f var5, Random var6);
    }
}

