/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import com.mojang.math.Vector3f;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.NumericParticle;

public class NewNumericParticlePacket {
    private final double value;
    private final Vector3f position;
    private final int colour;

    public NewNumericParticlePacket(double value, Vector3f position, int colour) {
        this.value = value;
        this.position = position;
        this.colour = colour;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.value);
        buf.writeFloat(this.position.m_122239_());
        buf.writeFloat(this.position.m_122260_());
        buf.writeFloat(this.position.m_122269_());
        buf.m_130130_(this.colour);
    }

    public static NewNumericParticlePacket decode(FriendlyByteBuf buf) {
        return new NewNumericParticlePacket(buf.readDouble(), new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()), buf.m_130242_());
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> TESParticleManager.addParticle(new NumericParticle(null, this.position, this.value).withColour(this.colour)));
        context.get().setPacketHandled(true);
    }
}

