/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.mixin.common.WalkAnimationStateAccess;

public final class TESClientUtil {
    public static final ResourceLocation CREATIVE_INVENTORY_TEXTURE = new ResourceLocation("textures/gui/container/creative_inventory/tab_inventory.png");

    public static void renderCenteredText(String text, PoseStack poseStack, Font fontRenderer, float x, float y, int colour) {
        TESClientUtil.renderCenteredText((Component)Component.m_237113_((String)text), poseStack, fontRenderer, x, y, colour);
    }

    public static void renderCenteredText(Component text, PoseStack poseStack, Font fontRenderer, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, text, x - (float)fontRenderer.m_92852_((FormattedText)text) / 2.0f, y + 4.0f, colour);
    }

    public static void positionFacingCamera(PoseStack poseStack) {
        poseStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
    }

    public static void prepRenderForTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void constructBarRender(PoseStack poseStack, int x, int y, int width, int v, float percentComplete, boolean withBarOverlay, float opacity) {
        int percentPixels = Math.round(percentComplete * (float)width);
        int midBarWidth = width - 10;
        TESClientUtil.drawSimpleTexture(poseStack, x, y, Math.min(5, percentPixels), 5, 0.0f, v, 256);
        if (percentPixels > 5) {
            if (midBarWidth > 0) {
                TESClientUtil.drawSimpleTexture(poseStack, x + 5, y, Math.min(midBarWidth, percentPixels - 5), 5, 5.0f, v, 256);
            }
            if (percentPixels > width - 5) {
                TESClientUtil.drawSimpleTexture(poseStack, x + 5 + midBarWidth, y, Math.min(5, percentPixels - 5), 5, 177.0f, v, 256);
            }
        }
        if (withBarOverlay && width > 10) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * opacity));
            TESClientUtil.drawSimpleTexture(poseStack, x, y, width, 5, 0.0f, 80.0f, 182, 5, 256, 256);
        }
    }

    public static void renderEntityIcon(PoseStack poseStack, Minecraft mc, float partialTick, LivingEntity entity, float opacity, boolean includeFrame) {
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.m_20205_(), 40.0f / entity.m_20206_()), 0.95f);
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        poseStack.m_85836_();
        if (includeFrame) {
            TESClientUtil.prepRenderForTexture(CREATIVE_INVENTORY_TEXTURE);
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * opacity));
            TESClientUtil.drawSimpleTexture(poseStack, 2, 2, 34, 45, 72.0f, 5.0f, 256);
            poseStack.m_252880_(20.0f, 25.0f, 0.0f);
            poseStack.m_85841_(-20.0f, -20.0f, 20.0f);
        }
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(0.0f, entity.m_20206_() * -0.5f, entity.m_20205_());
        float yBodyRotPrev = entity.f_20883_;
        float yRotPrev = entity.m_146908_();
        float xRotPrev = entity.m_146909_();
        float yHeadRotOldPrev = entity.f_20886_;
        float yHeadRotPrev = entity.f_20885_;
        int hurtTicks = entity.f_20916_;
        float walkPositionPrev = entity.f_267362_.m_267756_();
        float walkSpeedPrev = entity.f_267362_.m_267731_();
        float walkSpeedOldPrev = ((WalkAnimationStateAccess)entity.f_267362_).getSpeedOld();
        float attackTimePrev = entity.f_20921_;
        float attackTimeOldPrev = entity.f_20920_;
        entity.m_146922_(22.5f);
        entity.m_146926_(0.0f);
        entity.f_20883_ = 22.5f;
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        entity.f_20916_ = TESAPI.getConfig().hudEntityDamageOverlay() ? entity.f_20916_ : 0;
        ((WalkAnimationStateAccess)entity.f_267362_).setPosition(0.0f);
        ((WalkAnimationStateAccess)entity.f_267362_).setSpeed(0.0f);
        ((WalkAnimationStateAccess)entity.f_267362_).setSpeedOld(0.0f);
        entity.f_20921_ = 0.0f;
        entity.f_20920_ = 0.0f;
        Lighting.m_166384_();
        RenderSystem.m_69890_(() -> TESClientUtil.renderEntityRaw(poseStack, entity, partialTick, 0.0f, 0xF000F0, (MultiBufferSource)bufferSource));
        bufferSource.m_109911_();
        Lighting.m_84931_();
        entity.m_146922_(yRotPrev);
        entity.m_146926_(xRotPrev);
        entity.f_20883_ = yBodyRotPrev;
        entity.f_20885_ = yHeadRotPrev;
        entity.f_20886_ = yHeadRotOldPrev;
        entity.f_20916_ = hurtTicks;
        ((WalkAnimationStateAccess)entity.f_267362_).setPosition(walkPositionPrev);
        ((WalkAnimationStateAccess)entity.f_267362_).setSpeedOld(walkSpeedOldPrev);
        ((WalkAnimationStateAccess)entity.f_267362_).setSpeed(walkSpeedPrev);
        entity.f_20921_ = attackTimePrev;
        entity.f_20920_ = attackTimeOldPrev;
        poseStack.m_85849_();
    }

    public static <T extends Entity> void renderEntityRaw(PoseStack poseStack, T entity, float partialTick, float rotYaw, int packedLight, MultiBufferSource bufferSource) {
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = entityRenderDispatcher.m_114382_(entity);
        try {
            Vec3 renderOffset = entityRenderer.m_7860_(entity, partialTick);
            poseStack.m_85836_();
            poseStack.m_85837_(renderOffset.f_82479_, renderOffset.f_82480_, renderOffset.f_82481_);
            entityRenderer.m_7392_(entity, rotYaw, 1.0f, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
        catch (Exception ex) {
            CrashReport wrappedReport = CrashReport.m_127521_((Throwable)ex, (String)"Rendering entity in world");
            CrashReportCategory entityReportCategory = wrappedReport.m_127514_("Entity being rendered");
            entity.m_7976_(entityReportCategory);
            CrashReportCategory rendererReportCategory = wrappedReport.m_127514_("Renderer details");
            rendererReportCategory.m_128159_("Assigned renderer", (Object)entityRenderer);
            throw new ReportedException(wrappedReport);
        }
    }

    public static void drawSimpleTexture(PoseStack poseStack, int posX, int posY, int width, int height, float u, float v, int pngSize) {
        TESClientUtil.drawSimpleTexture(poseStack, posX, posY, width, height, u, v, width, height, pngSize, pngSize);
    }

    public static void drawSimpleTexture(PoseStack poseStack, int posX, int posY, int width, int height, float u, float v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Gui.m_93160_((PoseStack)poseStack, (int)posX, (int)posY, (int)width, (int)height, (float)u, (float)v, (int)uWidth, (int)vHeight, (int)pngWidth, (int)pngHeight);
    }

    public static void drawText(PoseStack poseStack, String text, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, (Component)Component.m_237113_((String)text), x, y, colour);
    }

    public static void drawText(PoseStack poseStack, Component text, float x, float y, int colour) {
        Minecraft.m_91087_().f_91062_.m_92889_(poseStack, text, x, y, colour);
    }

    public static void drawTextWithShadow(PoseStack poseStack, String text, float x, float y, int colour) {
        TESClientUtil.drawText(poseStack, (Component)Component.m_237113_((String)text), x, y, colour);
    }

    public static void drawTextWithShadow(PoseStack poseStack, Component text, float x, float y, int colour) {
        Minecraft.m_91087_().f_91062_.m_92763_(poseStack, text, x, y, colour);
    }

    public static void drawColouredSquare(PoseStack poseStack, int posX, int posY, int width, int height, int colour) {
        Gui.m_93172_((PoseStack)poseStack, (int)posX, (int)posY, (int)(posX + width), (int)(posY + height), (int)colour);
    }

    public static String translateKey(String key, Object ... args) {
        return I18n.m_118938_((String)key, (Object[])args);
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

