/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.tes.api.TESConstants;

public class RequestEffectsPacket {
    private final int entityId;

    public RequestEffectsPacket(int entityId) {
        this.entityId = entityId;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
    }

    public static RequestEffectsPacket decode(FriendlyByteBuf buf) {
        return new RequestEffectsPacket(buf.m_130242_());
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ((NetworkEvent.Context)context.get()).getSender().m_9236_().m_6815_(this.entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Collection effects = livingEntity.m_21220_();
                ObjectOpenHashSet ids = new ObjectOpenHashSet(effects.size());
                for (MobEffectInstance instance : effects) {
                    if (!instance.m_19572_() && !instance.m_19575_()) continue;
                    ids.add(ForgeRegistries.MOB_EFFECTS.getKey((Object)instance.m_19544_()));
                }
                TESConstants.NETWORKING.sendEffectsSync(((NetworkEvent.Context)context.get()).getSender(), this.entityId, (Set<ResourceLocation>)ids, Set.of());
            }
        });
        context.get().setPacketHandled(true);
    }
}

