/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESEntityType;
import net.tslat.tes.api.TESHudElement;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.element.BuiltinHudElements;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public class TESHud {
    private static final Map<String, TESHudElement> ELEMENTS = (Map)class_156.method_654(Collections.synchronizedMap(new Object2ObjectArrayMap()), map -> {
        map.put("EntityName", BuiltinHudElements::renderEntityName);
        map.put("HealthBar", BuiltinHudElements::renderEntityHealth);
        map.put("Armour", BuiltinHudElements::renderEntityArmour);
        map.put("Icons", BuiltinHudElements::renderEntityIcons);
        map.put("Effects", BuiltinHudElements::renderEntityEffects);
    });
    private static TESHudElement[] INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
    private static class_1309 TARGET_ENTITY = null;
    private static long TARGET_EXPIRY_TIME = -1L;

    public static void setTargetEntity(class_1309 entity) {
        TARGET_ENTITY = entity;
        TARGET_EXPIRY_TIME = class_310.method_1551().field_1687.method_8510() + 1L + (long)TESAPI.getConfig().hudTargetGracePeriod();
    }

    public static class_1309 getTargetEntity() {
        return TARGET_ENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHudElement(String name, TESHudElement element) {
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            ELEMENTS.put(name, element);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeHudElement(String name) {
        AtomicBoolean removed = new AtomicBoolean(false);
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            removed.set(ELEMENTS.remove(name) != null);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
        return removed.get();
    }

    public static void renderForHud(class_4587 poseStack, class_310 mc, float partialTick) {
        if (TARGET_ENTITY == null) {
            return;
        }
        if (!TARGET_ENTITY.method_5805() || TESHud.TARGET_ENTITY.field_6002 != mc.field_1687 || mc.field_1687.method_8510() > TARGET_EXPIRY_TIME) {
            TARGET_ENTITY = null;
            return;
        }
        if (!TESAPI.getConfig().hudEnabled() || !TESAPI.getConfig().hudBossesEnabled() && TESConstants.UTILS.getEntityType(TARGET_ENTITY) == TESEntityType.BOSS) {
            return;
        }
        float hudOpacity = TESAPI.getConfig().hudOpacity();
        poseStack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
        if (TESAPI.getConfig().hudEntityRender()) {
            TESClientUtil.renderEntityIcon(poseStack, mc, partialTick, TARGET_ENTITY, hudOpacity, true);
            poseStack.method_46416(40.0f, 0.0f, 0.0f);
        }
        poseStack.method_46416(0.0f, 2.0f, 0.0f);
        for (TESHudElement element : ELEMENTS.values()) {
            int offset = element.render(poseStack, mc, partialTick, TARGET_ENTITY, hudOpacity, false);
            if (offset <= 0) continue;
            poseStack.method_46416(0.0f, (float)(2 + offset), 0.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22909();
    }

    public static void renderInWorld(class_4587 poseStack, class_1309 entity, float partialTick) {
        if (!TESAPI.getConfig().inWorldBarsEnabled() || entity.method_29504() || entity == class_310.method_1551().field_1724 && !TESAPI.getConfig().inWorldHudForSelf()) {
            return;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || !TESAPI.getConfig().inWorldHUDActivation().test(entityState)) {
            return;
        }
        float hudOpacity = TESAPI.getConfig().inWorldHudOpacity();
        class_310 mc = class_310.method_1551();
        class_243 position = entity.method_30950(partialTick).method_1020(mc.field_1773.method_19418().method_19326()).method_1019(mc.method_1561().method_3953((class_1297)entity).method_23169((class_1297)entity, partialTick));
        poseStack.method_22903();
        poseStack.method_22904(position.field_1352, position.field_1351, position.field_1350);
        poseStack.method_46416(0.0f, entity.method_17682() + 0.5f, 0.0f);
        poseStack.method_46416(0.0f, TESConstants.CONFIG.inWorldHudManualVerticalOffset(), 0.0f);
        TESClientUtil.positionFacingCamera(poseStack);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22905(0.02f, 0.02f, 0.02f);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)hudOpacity);
        for (TESHudElement element : INVERSE_ELEMENTS) {
            int offset = element.render(poseStack, mc, partialTick, entity, hudOpacity, true);
            if (offset <= 0) continue;
            poseStack.method_46416(0.0f, (float)(-(2 + offset)), 0.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22909();
    }

    public static void pickNewEntity(float partialTick) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1692 != null) {
            class_1309 target = TESConstants.UTILS.getLivingEntityIfPossible(mc.field_1692);
            if (TESUtil.isVisibleToPlayer(target, TESClientUtil.getClientPlayer())) {
                TESHud.setTargetEntity(target);
            }
        } else {
            class_238 hitBounds;
            class_243 cameraView;
            class_243 rayEnd;
            class_243 cameraPos;
            double targetingRange = TESAPI.getConfig().getHudTargetDistance();
            class_1297 cameraEntity = mc.method_1560();
            class_3966 hitResult = class_1675.method_18075((class_1297)cameraEntity, (class_243)(cameraPos = cameraEntity.method_5836(partialTick)), (class_243)(rayEnd = cameraPos.method_1019((cameraView = cameraEntity.method_5828(partialTick)).method_18805(targetingRange, targetingRange, targetingRange))), (class_238)(hitBounds = cameraEntity.method_5829().method_18804(cameraView.method_1021(targetingRange)).method_1009(1.0, 1.0, 1.0)), entity -> !entity.method_7325() && entity.method_5863(), (double)(targetingRange * targetingRange));
            if (hitResult == null) {
                return;
            }
            class_1309 target = TESConstants.UTILS.getLivingEntityIfPossible(hitResult.method_17782());
            if (!TESUtil.isVisibleToPlayer(target, TESClientUtil.getClientPlayer())) {
                return;
            }
            double entityHitClipDistanceSqr = hitResult.method_17784().method_1025(cameraPos);
            targetingRange = Math.sqrt(entityHitClipDistanceSqr);
            rayEnd = cameraPos.method_1019(cameraView.method_18805(targetingRange, targetingRange, targetingRange));
            class_3965 blockHitResult = cameraEntity.field_6002.method_17742(new class_3959(cameraPos, rayEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, cameraEntity));
            if (blockHitResult == null || blockHitResult.method_17783() == class_239.class_240.field_1333 || blockHitResult.method_17784().method_1025(cameraPos) > entityHitClipDistanceSqr) {
                TESHud.setTargetEntity(target);
            }
        }
    }

    private static TESHudElement[] buildInverseElementArray(Collection<TESHudElement> elements) {
        TESHudElement[] array = new TESHudElement[elements.size()];
        int i = elements.size() - 1;
        for (TESHudElement element : elements) {
            array[i--] = element;
        }
        return array;
    }

    public static enum BarRenderType {
        NUMERIC,
        BAR,
        COMBINED;

    }
}

