/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.state.EntityState;

public final class TESEntityTracking {
    private static final Int2ObjectOpenHashMap<EntityState> ENTITY_STATES = new Int2ObjectOpenHashMap(50);
    private static List<class_1309> ENTITIES_TO_RENDER = new ObjectArrayList();
    private static IntSet RENDERED_NAMES = new IntOpenHashSet();

    public static void accountForEntity(class_1309 entity) {
        ENTITY_STATES.compute(entity.method_5628(), (key, value) -> {
            double trackingDist = TESAPI.getConfig().getEntityTrackingDistance();
            Object object = class_310.method_1551().field_1719 == null ? class_310.method_1551().field_1724 : class_310.method_1551().field_1719;
            if (entity.method_5858((class_1297)object) > trackingDist * trackingDist) {
                return null;
            }
            return value == null ? new EntityState(entity) : value;
        });
    }

    public static void tick() {
        TESParticleManager.clearClaims();
        ENTITY_STATES.values().forEach(EntityState::tick);
        if (class_310.method_1551().field_1687.method_8510() % (long)TESAPI.getConfig().getCacheCleanFrequency() == 0L) {
            ENTITY_STATES.values().removeIf(state -> !state.isValid());
        }
    }

    public static void addEntityToRender(class_1309 entity) {
        ENTITIES_TO_RENDER.add(entity);
    }

    @Nullable
    public static EntityState getStateForEntity(class_1309 entity) {
        return TESEntityTracking.getStateForEntityId(entity.method_5628());
    }

    @Nullable
    public static EntityState getStateForEntityId(int id) {
        return (EntityState)ENTITY_STATES.get(id);
    }

    public static List<class_1309> getEntitiesToRender() {
        List<class_1309> entities = ENTITIES_TO_RENDER;
        ENTITIES_TO_RENDER = new ObjectArrayList(ENTITIES_TO_RENDER.size());
        RENDERED_NAMES.clear();
        return entities;
    }

    public static boolean wasNameRendered(int entityId) {
        return RENDERED_NAMES.contains(entityId);
    }

    public static void markNameRendered(class_1309 entity) {
        RENDERED_NAMES.add(entity.method_5628());
    }
}

