/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.tslat.tes.TESClient;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.networking.NewComponentParticlePacket;
import net.tslat.tes.networking.NewNumericParticlePacket;
import net.tslat.tes.networking.ParticleClaimPacket;
import net.tslat.tes.networking.RequestEffectsPacket;
import net.tslat.tes.networking.SyncEffectsPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.quiltmc.qsl.networking.api.PacketByteBufs;
import org.quiltmc.qsl.networking.api.PlayerLookup;
import org.quiltmc.qsl.networking.api.ServerPlayNetworking;

public class TESNetworking
implements net.tslat.tes.core.networking.TESNetworking {
    public static boolean isSyncingEffects() {
        return TESAPI.getConfig().hudPotionIcons() || TESAPI.getConfig().inWorldHudPotionIcons();
    }

    @Override
    public void requestEffectsSync(int entityId) {
        if (!TESNetworking.isSyncingEffects()) {
            return;
        }
        class_2540 buffer = PacketByteBufs.create();
        new RequestEffectsPacket(entityId).encode(buffer);
        TESClient.sendPacket(RequestEffectsPacket.ID, buffer);
    }

    @Override
    public void sendEffectsSync(class_3222 player, int entityId, Set<class_2960> toAdd, Set<class_2960> toRemove) {
        if (!TESNetworking.isSyncingEffects()) {
            return;
        }
        class_2540 buffer = PacketByteBufs.create();
        new SyncEffectsPacket(entityId, toAdd, toRemove).encode(buffer);
        ServerPlayNetworking.send((class_3222)player, (class_2960)SyncEffectsPacket.ID, (class_2540)buffer);
    }

    @Override
    public void sendEffectsSync(class_1309 targetedEntity, Set<class_2960> toAdd, Set<class_2960> toRemove) {
        if (!TESNetworking.isSyncingEffects()) {
            return;
        }
        class_2540 buffer = PacketByteBufs.create();
        new SyncEffectsPacket(targetedEntity.method_5628(), toAdd, toRemove).encode(buffer);
        ServerPlayNetworking.send((Collection)PlayerLookup.tracking((class_1297)targetedEntity), (class_2960)SyncEffectsPacket.ID, (class_2540)buffer);
    }

    @Override
    public void sendParticle(class_1937 level, Vector3f position, class_2561 contents) {
        class_2540 buffer = PacketByteBufs.create();
        new NewComponentParticlePacket(position, contents).encode(buffer);
        ServerPlayNetworking.send((Collection)PlayerLookup.tracking((class_3218)((class_3218)level), (class_2338)class_2338.method_49637((double)position.x, (double)position.y, (double)position.z)), (class_2960)NewComponentParticlePacket.ID, (class_2540)buffer);
    }

    @Override
    public void sendParticle(class_1309 targetedEntity, class_2561 contents) {
        class_2540 buffer = PacketByteBufs.create();
        new NewComponentParticlePacket(targetedEntity, contents).encode(buffer);
        ServerPlayNetworking.send((Collection)PlayerLookup.tracking((class_1297)targetedEntity), (class_2960)NewComponentParticlePacket.ID, (class_2540)buffer);
    }

    @Override
    public void sendParticle(class_1937 level, Vector3f position, double value, int colour) {
        class_2540 buffer = PacketByteBufs.create();
        new NewNumericParticlePacket(value, position, colour).encode(buffer);
        ServerPlayNetworking.send((Collection)PlayerLookup.tracking((class_3218)((class_3218)level), (class_2338)class_2338.method_49637((double)position.x, (double)position.y, (double)position.z)), (class_2960)NewNumericParticlePacket.ID, (class_2540)buffer);
    }

    @Override
    public void sendParticle(class_1309 targetedEntity, double value, int colour) {
        class_2540 buffer = PacketByteBufs.create();
        new NewNumericParticlePacket(value, new Vector3f((float)targetedEntity.method_23317(), (float)targetedEntity.method_23320(), (float)targetedEntity.method_23321()), colour).encode(buffer);
        ServerPlayNetworking.send((Collection)PlayerLookup.tracking((class_1297)targetedEntity), (class_2960)NewNumericParticlePacket.ID, (class_2540)buffer);
    }

    @Override
    public void sendParticleClaim(class_2960 claimantId, class_1309 targetedEntity, @Nullable class_2487 additionalData) {
        class_2540 buffer = PacketByteBufs.create();
        new ParticleClaimPacket(targetedEntity.method_5628(), claimantId, additionalData).encode(buffer);
        ServerPlayNetworking.send((Collection)PlayerLookup.tracking((class_1297)targetedEntity), (class_2960)ParticleClaimPacket.ID, (class_2540)buffer);
    }
}

