/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.api;

import astramusfate.wizardry_tales.api.Wizard;
import astramusfate.wizardry_tales.registry.TalesItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.MagicDamage;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;

public class Sage {
    public static final String POTENCY = "potency";
    public static final String COST = "cost";
    public static final String CHARGEUP = "chargeup";
    public static final String PROGRESSION = "progression";
    public static final Item DURATION = WizardryItems.duration_upgrade;
    public static final Item ATTUNEMENT = WizardryItems.attunement_upgrade;
    public static final Item BLAST = WizardryItems.blast_upgrade;
    public static final Item CONDENSER = WizardryItems.condenser_upgrade;
    public static final Item COOLDOWN = WizardryItems.cooldown_upgrade;
    public static final Item MELEE = WizardryItems.melee_upgrade;
    public static final Item RANGE = WizardryItems.range_upgrade;
    public static final Item SIPHON = WizardryItems.siphon_upgrade;
    public static final Item STORAGE = WizardryItems.storage_upgrade;
    public static final Item CHANT_POWER = TalesItems.chant_upgrade_power;
    public static final Item CHANT_DURATION = TalesItems.chant_upgrade_duration;
    public static final Item CHANT_RANGE = TalesItems.chant_upgrade_range;
    public static final Item CHANT_DELAY = TalesItems.chant_upgrade_delay;
    public static final Item CHANT_COST = TalesItems.chant_upgrade_count;

    public static void smartDamage(String word, @Nullable EntityLivingBase caster, Entity living, float damage) {
        Element element;
        MagicDamage.DamageType type = Sage.getTypeByText(word);
        if (type == null) {
            element = Element.fromName((String)word, (Element)Element.MAGIC);
            assert (element != null);
            type = Sage.getTypeByElement(element);
        } else {
            element = Sage.getElementByType(type);
        }
        if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)type, (Entity)living)) {
            Sage.causeDamage(type, caster, living, damage);
        }
        Wizard.castParticles(living.field_70170_p, element, living.func_174791_d());
    }

    public static void causeDamage(MagicDamage.DamageType type, @Nullable EntityLivingBase caster, Entity living, float damage) {
        living.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)type), damage);
    }

    public static MagicDamage.DamageType getTypeByElement(Element element) {
        switch (element) {
            case FIRE: {
                return MagicDamage.DamageType.FIRE;
            }
            case ICE: {
                return MagicDamage.DamageType.FROST;
            }
            case LIGHTNING: {
                return MagicDamage.DamageType.SHOCK;
            }
            case NECROMANCY: {
                return MagicDamage.DamageType.WITHER;
            }
            case EARTH: {
                return MagicDamage.DamageType.POISON;
            }
            case SORCERY: {
                return MagicDamage.DamageType.FORCE;
            }
            case HEALING: {
                return MagicDamage.DamageType.RADIANT;
            }
        }
        return MagicDamage.DamageType.MAGIC;
    }

    public static Element getElementByType(MagicDamage.DamageType type) {
        if (type == null) {
            return Element.MAGIC;
        }
        switch (type) {
            case FIRE: {
                return Element.FIRE;
            }
            case FROST: {
                return Element.ICE;
            }
            case SHOCK: {
                return Element.LIGHTNING;
            }
            case WITHER: {
                return Element.NECROMANCY;
            }
            case POISON: {
                return Element.EARTH;
            }
            case FORCE: {
                return Element.SORCERY;
            }
            case RADIANT: {
                return Element.HEALING;
            }
        }
        return Element.MAGIC;
    }

    @Nullable
    public static MagicDamage.DamageType getTypeByText(String text) {
        try {
            return MagicDamage.DamageType.valueOf((String)text);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Element getElementByText(String text) {
        return Element.fromName((String)text, (Element)Element.MAGIC);
    }
}

