/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.api;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Selena {
    public static AttributeModifier newMod(UUID id, String name, double amount, int operation) {
        return new AttributeModifier(id, name, amount, operation);
    }

    public static void nullAttributes(EntityPlayer player, UUID uuid) {
        for (IAttributeInstance instance : player.func_110140_aT().func_111146_a()) {
            if (instance.func_111127_a(uuid) == null) continue;
            instance.func_188479_b(uuid);
        }
    }

    public static void nullAttributes(EntityPlayer player, UUID uuid, IAttributeInstance ... attributes) {
        for (IAttributeInstance attribute : attributes) {
            IAttributeInstance instance = player.func_110140_aT().func_111151_a(attribute.func_111123_a());
            if (instance.func_111127_a(uuid) == null) continue;
            instance.func_188479_b(uuid);
        }
    }

    public static void checkAttributes(IAttributeInstance check, UUID id, String name, double value, int operation) {
        AttributeModifier mod = Selena.newMod(id, name, value, operation).func_111168_a(true);
        if (!check.func_180374_a(mod)) {
            check.func_111121_a(mod);
        } else {
            AttributeModifier par = check.func_111127_a(id);
            if (par != null && par.func_111164_d() != value) {
                check.func_188479_b(id);
                check.func_111121_a(mod);
            }
        }
    }

    @Nullable
    public static <T extends EntityLivingBase> EntityLivingBase findNearestLiving(Vec3d position, List<T> list) {
        double distance = 16.0;
        EntityLivingBase nearest = null;
        if (list.isEmpty()) {
            return null;
        }
        for (EntityLivingBase entity : list) {
            if (!(distance > entity.func_70011_f(position.field_72450_a, position.field_72448_b, position.field_72449_c))) continue;
            distance = entity.func_70011_f(position.field_72450_a, position.field_72448_b, position.field_72449_c);
            nearest = entity;
        }
        return nearest;
    }

    public static <T extends Entity> Entity findNearest(Vec3d position, List<T> list) {
        double distance = 16.0;
        Entity nearest = null;
        for (Entity entity : list) {
            if (!(distance > entity.func_70011_f(position.field_72450_a, position.field_72448_b, position.field_72449_c))) continue;
            distance = entity.func_70011_f(position.field_72450_a, position.field_72448_b, position.field_72449_c);
            nearest = entity;
        }
        return nearest;
    }

    public static <T extends Entity> List<T> getAround(World world, double radius, BlockPos pos, Class<T> entityType, Predicate<? super T> removeIf) {
        List<T> list = Selena.getAround(world, radius, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityType);
        list.removeIf(removeIf);
        return list;
    }

    public static <T extends Entity> List<T> getAround(World world, double radius, BlockPos pos, Class<T> entityType) {
        return Selena.getAround(world, radius, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityType);
    }

    private static <T extends Entity> List<T> getAround(World world, double radius, double x, double y, double z, Class<T> entityType) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.func_72872_a(entityType, aabb);
        for (int i = 0; i < entityList.size(); ++i) {
            if (!(((Entity)entityList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityList.remove(i);
            break;
        }
        return entityList;
    }

    public static void pushOne(EntityLivingBase creature) {
        double dx = creature.field_70159_w;
        double dz = creature.field_70179_y;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        creature.func_70653_a((Entity)creature, 0.6f, dx, dz);
    }

    public static void pushEntity(Entity attacker, Entity target, float strength) {
        double xRatio = attacker.field_70165_t - target.field_70165_t;
        double zRatio = attacker.field_70161_v - target.field_70161_v;
        while (xRatio * xRatio + zRatio * zRatio < 1.0E-4) {
            xRatio = (Math.random() - Math.random()) * 0.01;
            zRatio = (Math.random() - Math.random()) * 0.01;
        }
        target.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        target.field_70159_w /= 2.0;
        target.field_70179_y /= 2.0;
        target.field_70159_w -= xRatio / (double)f * (double)strength;
        target.field_70179_y -= zRatio / (double)f * (double)strength;
        if (target.field_70122_E) {
            target.field_70181_x /= 2.0;
            target.field_70181_x += (double)strength;
            if (target.field_70181_x > (double)0.4f) {
                target.field_70181_x = 0.4f;
            }
        }
    }

    public static void pushOne(EntityLivingBase creature, float strength) {
        double dx = creature.field_70159_w;
        double dz = creature.field_70179_y;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        creature.func_70653_a((Entity)creature, strength, dx, dz);
    }

    public static void upgradeStat(EntityLiving living, IAttribute attribute, double upgrade, double max) {
        double value = living.func_110148_a(attribute).func_111125_b() + upgrade;
        if (value > max) {
            value = max;
        }
        living.func_110148_a(attribute).func_111128_a(value);
    }

    public static void upgradeStat(EntityLiving living, IAttribute attribute, double upgrade) {
        living.func_110148_a(attribute).func_111128_a(living.func_110148_a(attribute).func_111125_b() + upgrade);
    }
}

