/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.api;

import electroblob.wizardry.util.RayTracer;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Solver {
    public static final int ADD = 0;
    public static final int ADD_MULTIPLE = 1;
    public static final int MULTIPLY = 2;

    public static float normalize(float value, float min, float max) {
        return (value - min) / (max - min);
    }

    public static boolean doEvery(Entity entity, double seconds) {
        return entity.field_70173_aa % (int)(seconds * 20.0) == 0;
    }

    public static boolean doEvery(int Value, double seconds) {
        return Value % (int)(seconds * 20.0) == 0;
    }

    public static int percentOf(double value, double max) {
        return (int)(value / max) * 100;
    }

    public static int asTicks(double seconds) {
        return (int)(seconds * 20.0);
    }

    public static int duration(double seconds) {
        return (int)(seconds * 20.0);
    }

    public static double calcProgress(double value, double max) {
        return value / max;
    }

    public static double calcInvProgress(double progress) {
        return 1.0 - progress;
    }

    public static double asSeconds(double ticks) {
        return ticks / 20.0;
    }

    public static boolean rangeCheck(double value, double range_min, double range_max) {
        return value >= range_min && value <= range_max;
    }

    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static float randFloat(float min, float max) {
        Random r = new Random();
        return min + r.nextFloat() * (max - min);
    }

    public static double randDouble(double min, double max) {
        Random r = new Random();
        return min + r.nextDouble() * (max - min);
    }

    public static double range(double value) {
        return Solver.randDouble(-value, value);
    }

    public static boolean chance(int chance) {
        return Solver.randInt(1, 100) <= chance;
    }

    public static int biggestInt(int[] integers) {
        int biggest = 0;
        int index = 0;
        for (int i = 0; i < integers.length; ++i) {
            int value = integers[i];
            if (biggest >= value) continue;
            biggest = value;
            index = i;
        }
        return index;
    }

    public static float limit(float value, float max) {
        return Math.min(value, max);
    }

    public static boolean invert(boolean bool) {
        return !bool;
    }

    @Nullable
    public static RayTraceResult standardBlockRayTrace(World world, Entity entity, double range, boolean hitLiquids, boolean ignoreUncollidables, boolean returnLastUncollidable) {
        Vec3d origin = entity.func_174824_e(1.0f);
        Vec3d endpoint = origin.func_178787_e(entity.func_70040_Z().func_186678_a(range));
        return world.func_147447_a(origin, endpoint, hitLiquids, ignoreUncollidables, returnLastUncollidable);
    }

    @Nullable
    public static RayTraceResult standardBlockRayTrace(World world, Entity entity, double range, boolean hitLiquids) {
        return Solver.standardBlockRayTrace(world, entity, range, hitLiquids, false, false);
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, Entity entity, double range, boolean hitLiquids, Predicate<Entity> ignore) {
        Vec3d origin = entity.func_174824_e(1.0f);
        Vec3d endpoint = origin.func_178787_e(entity.func_70040_Z().func_186678_a(range));
        return RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)0.0f, (boolean)hitLiquids, (boolean)true, (boolean)false, Entity.class, ignore);
    }
}

