/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.api;

import astramusfate.wizardry_tales.registry.TalesItems;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class Thief {
    public static boolean hasItem(EntityPlayer player, Item item) {
        if (player.func_184812_l_()) {
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItem(EntityPlayer player, Item item) {
        if (player.func_184812_l_()) {
            return new ItemStack(item);
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() != item) continue;
            return stack;
        }
        if (item == player.func_184614_ca().func_77973_b()) {
            return player.func_184614_ca();
        }
        if (item == player.func_184592_cb().func_77973_b()) {
            return player.func_184592_cb();
        }
        return null;
    }

    public static ItemStack getItem(EntityPlayer player, Predicate<ItemStack> item, ItemStack creative) {
        if (item.test(player.func_184614_ca())) {
            return player.func_184614_ca();
        }
        if (item.test(player.func_184592_cb())) {
            return player.func_184592_cb();
        }
        if (player.func_184812_l_() && creative != null) {
            return creative;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!item.test(stack)) continue;
            return stack;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!item.test(stack)) continue;
            return stack;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (!item.test(stack)) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack getItem(EntityPlayer player, Predicate<ItemStack> item) {
        return Thief.getItem(player, item, null);
    }

    public static boolean noItemsInHands(EntityLivingBase player) {
        return player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_190931_a && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == Items.field_190931_a;
    }

    public static boolean testPredicateHands(EntityLivingBase player, Predicate<ItemStack> predicate) {
        return predicate.test(player.func_184586_b(EnumHand.MAIN_HAND)) && predicate.test(player.func_184586_b(EnumHand.OFF_HAND));
    }

    public static boolean checkInventory(EntityPlayer player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean checkArmor(EntityPlayer player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean checkHands(EntityPlayer player, Item item) {
        return player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == item || player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == item;
    }

    @Nullable
    public static ItemStack getInHands(EntityPlayer player) {
        ItemStack left = player.func_184592_cb();
        ItemStack right = player.func_184614_ca();
        if (left.func_190926_b() && right.func_190926_b()) {
            return null;
        }
        if (right.func_190926_b()) {
            return left;
        }
        return right;
    }

    @Nullable
    public static ItemStack getInHands(EntityPlayer player, Predicate<ItemStack> predicate) {
        ItemStack left = player.func_184592_cb();
        ItemStack right = player.func_184614_ca();
        if (right.func_190926_b() && predicate.test(left)) {
            return left;
        }
        if (!right.func_190926_b() && predicate.test(right)) {
            return right;
        }
        return null;
    }

    @Nullable
    public static ItemStack getSpellCasting(EntityLivingBase player) {
        ItemStack left = player.func_184592_cb();
        ItemStack right = player.func_184614_ca();
        if (right.func_77973_b() instanceof ISpellCastingItem) {
            return right;
        }
        if (left.func_77973_b() instanceof ISpellCastingItem) {
            return left;
        }
        return null;
    }

    @Nullable
    public static ItemStack getInHands(EntityLivingBase player, Item item) {
        ItemStack left = player.func_184592_cb();
        ItemStack right = player.func_184614_ca();
        if (right.func_77973_b() == item) {
            return right;
        }
        if (left.func_77973_b() == item) {
            return left;
        }
        return null;
    }

    @Nullable
    public static EnumHand getHand(EntityLivingBase player, Item item) {
        ItemStack left = player.func_184592_cb();
        ItemStack right = player.func_184614_ca();
        if (right.func_77973_b() == item) {
            return EnumHand.MAIN_HAND;
        }
        if (left.func_77973_b() == item) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    public static boolean checkOffhand(EntityPlayer player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean addItem(EntityPlayer player, Item item) {
        return player.func_191521_c(new ItemStack(item, 1));
    }

    public static boolean addItem(EntityPlayer player, ItemStack stack) {
        return player.func_191521_c(stack);
    }

    public static ItemStack stack(Item item) {
        return new ItemStack(item, 1, 0);
    }

    public static ItemStack stack(Item item, int meta) {
        return new ItemStack(item, 1, meta);
    }

    public static ItemStack stacked(Item item, int count, int meta) {
        return new ItemStack(item, count, meta);
    }

    public static ItemStack getWandInUse(EntityPlayer player) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)TalesItems.casting_ring) && Thief.testPredicateHands((EntityLivingBase)player, i -> !(i.func_77973_b() instanceof ISpellCastingItem))) {
            return Thief.getItem(player, (ItemStack item) -> item.func_77973_b() instanceof ISpellCastingItem && item.func_77973_b() instanceof IManaStoringItem);
        }
        return null;
    }

    public static ItemStack getWandInUseUniversal(EntityPlayer player) {
        if (Thief.testPredicateHands((EntityLivingBase)player, i -> !(i.func_77973_b() instanceof ISpellCastingItem))) {
            return Thief.getItem(player, (ItemStack item) -> item.func_77973_b() instanceof ISpellCastingItem && item.func_77973_b() instanceof IManaStoringItem);
        }
        return null;
    }
}

