/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.api;

import astramusfate.wizardry_tales.api.Solver;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.entity.construct.EntityMagicCircle;
import astramusfate.wizardry_tales.entity.construct.sigils.EntityMagicCircleVertical;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.util.ParticleBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Wizard {
    public static void conjureCircle(World world, Element element, Vec3d pos) {
        EntityMagicCircle entity = new EntityMagicCircle(world);
        entity.setLocation(element == null ? "u_magic" : "u_" + element.func_176610_l());
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b + Tales.effects.y_offset, pos.field_72449_c);
        entity.lifetime = Solver.asTicks(1.0);
        entity.chooseSize();
        entity.setSizeMultiplier((float)Tales.effects.circle_size);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entity);
        }
    }

    public static void conjureCircle(World world, String location, Vec3d pos) {
        EntityMagicCircle entity = Wizard.getCircle(world, location, pos);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entity);
        }
    }

    public static EntityMagicCircle getCircle(World world, String location, Vec3d pos) {
        EntityMagicCircle entity = new EntityMagicCircle(world);
        entity.setLocation(location);
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b + Tales.effects.y_offset, pos.field_72449_c);
        entity.lifetime = Solver.asTicks(1.0);
        entity.chooseSize();
        entity.setSizeMultiplier((float)Tales.effects.circle_size);
        return entity;
    }

    public static EntityMagicCircleVertical getVerticalCircle(World world, String location, Vec3d pos, Entity rotations) {
        EntityMagicCircleVertical entity = new EntityMagicCircleVertical(world);
        entity.setLocation(location);
        entity.lifetime = Solver.asTicks(1.0);
        Vec3d view = rotations.func_70040_Z().func_186678_a(Tales.effects.look_distance);
        Vec3d look = new Vec3d(pos.field_72450_a + view.field_72450_a, pos.field_72448_b + Tales.effects.look_y_offset + view.field_72448_b, pos.field_72449_c + view.field_72449_c);
        entity.chooseSize();
        entity.setSizeMultiplier((float)Tales.effects.vertical_circle_size);
        entity.func_70080_a(look.field_72450_a, look.field_72448_b, look.field_72449_c, rotations.field_70177_z, rotations.field_70125_A);
        return entity;
    }

    public static void conjureVerticalCircle(World world, Element element, Vec3d pos, Entity rotations) {
        EntityMagicCircleVertical entity = new EntityMagicCircleVertical(world);
        entity.setLocation(element == null ? "u_magic" : "u_" + element.func_176610_l());
        entity.lifetime = Solver.asTicks(1.0);
        Vec3d view = rotations.func_70040_Z().func_186678_a(Tales.effects.look_distance);
        Vec3d look = new Vec3d(pos.field_72450_a + view.field_72450_a, pos.field_72448_b + Tales.effects.look_y_offset + view.field_72448_b, pos.field_72449_c + view.field_72449_c);
        entity.chooseSize();
        entity.setSizeMultiplier((float)Tales.effects.vertical_circle_size);
        entity.func_70080_a(look.field_72450_a, look.field_72448_b, look.field_72449_c, rotations.field_70177_z, rotations.field_70125_A);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entity);
        }
    }

    public static void conjureVerticalCircle(World world, String location, Vec3d pos, Entity rotations) {
        EntityMagicCircleVertical entity = Wizard.getVerticalCircle(world, location, pos, rotations);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entity);
        }
    }

    public static void castParticles(World world, Element element, Vec3d pos) {
        Wizard.castParticles(world, element, pos, 18);
    }

    public static void castParticles(World world, Element element, Vec3d pos, int count) {
        if (world.field_72995_K) {
            block9: for (int i = 0; i < count; ++i) {
                double x = pos.field_72450_a + Solver.range(2.0);
                double y = pos.field_72448_b + Solver.range(2.0);
                double z = pos.field_72449_c + Solver.range(2.0);
                ResourceLocation type = ParticleBuilder.Type.SPARKLE;
                switch (element) {
                    case FIRE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(1.0f, 1.0f, 1.0f).spawn(world);
                        continue block9;
                    }
                    case ICE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SNOW).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).spawn(world);
                        continue block9;
                    }
                    case LIGHTNING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos(x, y, z).spawn(world);
                        continue block9;
                    }
                    case NECROMANCY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0x800080).spawn(world);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(9699539).spawn(world);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(4915330).vel(0.0, -0.1, 0.0).spawn(world);
                        continue block9;
                    }
                    case EARTH: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).spawn(world);
                        continue block9;
                    }
                    case SORCERY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(0.2f, 0.6f, 1.0f).spawn(world);
                        continue block9;
                    }
                    case HEALING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(0.8f, 1.0f, 0.5f).spawn(world);
                        continue block9;
                    }
                    default: {
                        ParticleBuilder.create((ResourceLocation)type).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(1.0f, 1.0f, 1.0f).spawn(world);
                    }
                }
            }
        }
    }

    public static void castParticlesWithoutRange(World world, Element element, Vec3d pos, int count) {
        if (world.field_72995_K) {
            block9: for (int i = 0; i < count; ++i) {
                double x = pos.field_72450_a;
                double y = pos.field_72448_b;
                double z = pos.field_72449_c;
                ResourceLocation type = ParticleBuilder.Type.SPARKLE;
                switch (element) {
                    case FIRE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(1.0f, 1.0f, 1.0f).spawn(world);
                        continue block9;
                    }
                    case ICE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SNOW).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).spawn(world);
                        continue block9;
                    }
                    case LIGHTNING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos(x, y, z).spawn(world);
                        continue block9;
                    }
                    case NECROMANCY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0x800080).spawn(world);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(9699539).spawn(world);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(4915330).vel(0.0, -0.1, 0.0).spawn(world);
                        continue block9;
                    }
                    case EARTH: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).spawn(world);
                        continue block9;
                    }
                    case SORCERY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(0.2f, 0.6f, 1.0f).spawn(world);
                        continue block9;
                    }
                    case HEALING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(0.8f, 1.0f, 0.5f).spawn(world);
                        continue block9;
                    }
                    default: {
                        ParticleBuilder.create((ResourceLocation)type).collide(true).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).clr(1.0f, 1.0f, 1.0f).spawn(world);
                    }
                }
            }
        }
    }

    public static void castParticles(World world, EnumParticleTypes types, Vec3d pos, Vec3d motion, int count) {
        if (world.field_72995_K) {
            for (int i = 0; i < count; ++i) {
                double x = pos.field_72450_a + Solver.range(2.0);
                double y = pos.field_72448_b + Solver.range(2.0);
                double z = pos.field_72449_c + Solver.range(2.0);
                world.func_175688_a(types, x, y, z, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, new int[0]);
            }
        }
    }

    public static void castBuff(World world, Entity entity, int color) {
        Wizard.castBuff(world, entity, color, 18);
    }

    public static void castBuff(World world, Entity entity, int color, int particleCount) {
        if (world.field_72995_K) {
            for (int i = 0; i < particleCount; ++i) {
                double x = entity.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                double y = entity.field_70163_u + (double)entity.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
                double z = entity.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(color).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity(entity).clr(color).spawn(world);
        }
    }
}

