/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.blocks;

import astramusfate.wizardry_tales.api.classes.IActionableBlock;
import astramusfate.wizardry_tales.blocks.tile.TileEntityBlooming;
import astramusfate.wizardry_tales.entity.construct.EntityPoisonousGas;
import astramusfate.wizardry_tales.registry.TalesItems;
import astramusfate.wizardry_tales.spells.TalesSpells;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBush;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockBloomingFlower
extends BlockBush
implements ITileEntityProvider,
IActionableBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.3f, (double)0.7f);

    public BlockBloomingFlower(Material par2Material) {
        super(par2Material);
        this.func_149715_a(0.4f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
    }

    public boolean func_149703_v() {
        return true;
    }

    public void func_180634_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        if (EntityUtils.isLiving((Entity)entity)) {
            this.action(world, pos, (EntityLivingBase)entity);
        }
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public EnumPlantType getPlantType(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return EnumPlantType.Plains;
    }

    @Override
    public void action(World world, BlockPos pos, EntityLivingBase target) {
        TileEntityBlooming tile;
        TileEntityBlooming tileEntityBlooming = tile = world.func_175625_s(pos) instanceof TileEntityBlooming ? (TileEntityBlooming)world.func_175625_s(pos) : null;
        if (tile != null) {
            EntityPlayer caster;
            if (!world.field_72995_K && (caster = tile.getCaster()) != null && caster != target && AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target)) {
                if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)TalesItems.amulet_petal_blooming)) {
                    SpellModifiers spellModifiers = new SpellModifiers();
                    spellModifiers.set(WizardryItems.duration_upgrade, (float)tile.getDurationMod(), false);
                    spellModifiers.set("potency", (float)tile.getPotencyMod(), false);
                    EntityPoisonousGas gas = new EntityPoisonousGas(world, spellModifiers);
                    gas.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    gas.setCaster((EntityLivingBase)caster);
                    gas.setLifetime((int)Math.floor((double)TalesSpells.blooming.getProperty("duration").intValue() * tile.getDurationMod()));
                    world.func_72838_d((Entity)gas);
                } else {
                    EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)tile.getCaster(), (MagicDamage.DamageType)MagicDamage.DamageType.POISON), (float)1.0f);
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)TalesSpells.blooming.getProperty("effect_duration").floatValue(), TalesSpells.blooming.getProperty("effect_strength").intValue()));
                }
                world.func_175655_b(pos, false);
            }
            tile.spawnParticleEffect();
        }
    }

    public boolean hasTileEntity(@Nonnull IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileEntityBlooming(worldIn);
    }
}

