/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.data;

import astramusfate.wizardry_tales.api.Aterna;
import astramusfate.wizardry_tales.api.classes.IChestManaCollector;
import astramusfate.wizardry_tales.data.EventsBase;
import astramusfate.wizardry_tales.data.Lexicon;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.SoulProvider;
import astramusfate.wizardry_tales.data.chanting.SpellParam;
import astramusfate.wizardry_tales.entity.construct.EntityMagic;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ChantWorker
extends EventsBase
implements Lexicon {
    public static boolean useMana(Entity focal, double cost, boolean addProgress) {
        EntityMagic magic;
        if (cost < 0.0) {
            cost *= -1.0;
        }
        if (!Tales.mp.manaPool) {
            return true;
        }
        cost *= Tales.mp.chant_multiplier;
        if (focal instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)focal;
            return ChantWorker.collectMana(player, cost, addProgress);
        }
        if (focal instanceof EntityMagic && (magic = (EntityMagic)focal).getCaster() instanceof EntityPlayer) {
            if (ChantWorker.chestUseMana(magic, cost)) {
                return true;
            }
            EntityPlayer player = (EntityPlayer)magic.getCaster();
            return ChantWorker.collectMana(player, cost, addProgress);
        }
        return false;
    }

    public static boolean chestUseMana(Entity magic, double cost) {
        if (magic == null) {
            return false;
        }
        if (!(magic instanceof IChestManaCollector)) {
            return false;
        }
        float range = ((IChestManaCollector)magic).getChestArea();
        List positions = BlockUtils.getBlockSphere((BlockPos)magic.func_180425_c(), (double)range);
        boolean result = false;
        if (positions.isEmpty()) {
            return false;
        }
        block0: for (BlockPos pos : positions) {
            TileEntity tile = magic.field_70170_p.func_175625_s(pos);
            if (result) break;
            if (tile == null || !(tile instanceof TileEntityChest) || !tile.getTileData().func_186855_b("arcaneLockOwner")) continue;
            TileEntityChest chest = (TileEntityChest)tile;
            NBTTagCompound tag = new NBTTagCompound();
            chest.func_189515_b(tag);
            NonNullList stacks = NonNullList.func_191196_a();
            ItemStackHelper.func_191283_b((NBTTagCompound)tag, (NonNullList)stacks);
            for (ItemStack stack : stacks) {
                IManaStoringItem mana;
                if (!(stack.func_77973_b() instanceof IManaStoringItem) || (mana = (IManaStoringItem)stack.func_77973_b()).getManaCapacity(stack) < (int)Math.round(cost)) continue;
                mana.consumeMana(stack, (int)Math.round(cost), null);
                magic.field_70170_p.markAndNotifyBlock(pos, null, magic.field_70170_p.func_180495_p(pos), magic.field_70170_p.func_180495_p(pos), 3);
                result = true;
                continue block0;
            }
        }
        return result;
    }

    public static boolean useMana(Entity focal, double cost) {
        return ChantWorker.useMana(focal, cost, false);
    }

    public static double calc(double result, double with) {
        return result * with;
    }

    public static double calc(double result, double with, double pow) {
        return result * Math.pow(with, pow);
    }

    public static boolean useMana(Entity focal, double cost, float ... modifiers) {
        for (float modifier : modifiers) {
            cost *= (double)modifier;
        }
        return ChantWorker.useMana(focal, cost);
    }

    public static boolean collectMana(EntityPlayer player, double cost, boolean progress) {
        if (!Tales.mp.manaPool) {
            return true;
        }
        ISoul soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul == null) {
            return false;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        if (soul.getMP() >= cost) {
            soul.addMana(player, -1.0 * cost);
            if (progress) {
                double maxMana = soul.getMaxMP();
                double value = maxMana + Math.max(Tales.mp.progression * (Tales.mp.progression_multiplier * (cost / maxMana)), Tales.mp.progression);
                soul.setMaxMP(player, Math.min(value, Tales.mp.max));
            }
            return true;
        }
        if (!player.field_70170_p.field_72995_K) {
            Aterna.translate(player, true, "mana.not_enough");
        }
        return false;
    }

    public static boolean collectMana(EntityPlayer player, double cost) {
        return ChantWorker.collectMana(player, cost, false);
    }

    public static boolean useMana(EntityPlayer player, ItemStack stack, int cost) {
        IManaStoringItem mana;
        if (stack.func_77973_b() instanceof IManaStoringItem && (mana = (IManaStoringItem)stack.func_77973_b()).getMana(stack) >= cost) {
            mana.consumeMana(stack, cost, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    public static boolean optional(List<String> words, String first, String second) {
        return ChantWorker.contains(words, first) || ChantWorker.contains(words, second);
    }

    public static boolean contains(List<String> words, String matches) {
        String[] to_match = matches.split(" ");
        ArrayList contained = new ArrayList(Collections.emptyList());
        for (String match : to_match) {
            contained.add(words.contains(match));
        }
        return contained.stream().allMatch(bool -> bool);
    }

    public static boolean containsAll(List<String> words, List<String> matching) {
        ArrayList contained = new ArrayList(Collections.emptyList());
        for (String matches : matching) {
            String[] to_match;
            for (String match : to_match = matches.split(" ")) {
                contained.add(words.contains(match));
            }
        }
        return contained.stream().allMatch(bool -> bool);
    }

    public static boolean containsAny(List<String> words, List<String> matching) {
        ArrayList contained = new ArrayList(Collections.emptyList());
        for (String matches : matching) {
            String[] to_match;
            for (String match : to_match = matches.split(" ")) {
                contained.add(words.contains(match));
            }
        }
        return contained.stream().anyMatch(bool -> bool);
    }

    public static boolean containsRightAfter(List<String> words, String matches, int tolerance) {
        String[] to_match = matches.split(" ");
        ArrayList contained = new ArrayList(Collections.emptyList());
        int count = -1;
        for (String match : to_match) {
            if (words.contains(match)) {
                count = tolerance + 1;
            } else if (count > 0) {
                --count;
            }
            if (count == 0) break;
            contained.add(words.contains(match));
        }
        return contained.stream().allMatch(bool -> bool);
    }

    public static boolean containsRightAfter(List<String> words, int tolerance, String ... matches) {
        ArrayList contained = new ArrayList(Collections.emptyList());
        boolean matched = false;
        int count = -1;
        for (String part : matches) {
            String[] to_match;
            for (String match : to_match = part.split(" ")) {
                contained.add(words.contains(match));
                if (!words.contains(match)) continue;
                matched = true;
            }
            if (matched) {
                count = tolerance + 1;
            } else if (count > 0) {
                --count;
            }
            if (count == 0) break;
        }
        return contained.stream().allMatch(bool -> bool);
    }

    public static List<String> removeIfFind(List<String> words, String matches) {
        List<String> finality = words;
        for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            String next = i + 1 < words.size() ? words.get(i + 1) : "";
            if (!ChantWorker.findIn(matches, word) || !ChantWorker.findIn(matches, next)) continue;
            finality.remove(i);
            finality.remove(i + 1);
        }
        return finality;
    }

    public static boolean findIn(String match, String matches) {
        String[] to_match;
        for (String matchy : to_match = matches.split(" ")) {
            if (!matchy.equals(match)) continue;
            return true;
        }
        return false;
    }

    public static boolean findInSmart(String see, String matches) {
        String[] to_see;
        String[] to_match = matches.split(" ");
        for (String match : to_see = see.split(" ")) {
            for (String matchy : to_match) {
                if (!matchy.equals(match)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean findAny(String match, String ... matches) {
        for (String matching : matches) {
            String[] to_match;
            for (String matchy : to_match = matching.split(" ")) {
                if (!matchy.equals(match)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean findIn(String match, String ... matches) {
        int count = 0;
        for (String matching : matches) {
            String[] to_match;
            for (String matchy : to_match = matching.split(" ")) {
                if (!matchy.equals(match)) continue;
                ++count;
            }
        }
        return count == matches.length;
    }

    public static void processParameters(String word, String previous, String next, List<SpellParam> params) {
        boolean error = false;
        float number = 1.0f;
        try {
            number = Float.parseFloat(word);
        }
        catch (NumberFormatException ignore) {
            error = true;
        }
        if (error) {
            try {
                number = Float.parseFloat(next);
                error = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (error) {
            return;
        }
        for (SpellParam param : params) {
            if (!ChantWorker.findIn(param.name(), previous)) continue;
            param.setNumber(Float.valueOf(number));
        }
    }

    public static void spawnParticleRay(World world, EnumParticleTypes type, Vec3d origin, Vec3d direction, double distance) {
        Vec3d velocity = direction.func_186678_a(0.0);
        for (double d = 0.85; d <= distance; d += 0.85) {
            double x = origin.field_72450_a + d * direction.field_72450_a + 0.1 * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double y = origin.field_72448_b + d * direction.field_72448_b + 0.1 * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            double z = origin.field_72449_c + d * direction.field_72449_c + 0.1 * (world.field_73012_v.nextDouble() * 2.0 - 1.0);
            ChantWorker.spawnParticle(world, type, x, y, z);
        }
    }

    public static void spawnParticle(World world, EnumParticleTypes type, double x, double y, double z) {
        world.func_175688_a(type, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    public static boolean toggleLock(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null) {
            if (tileentity.getTileData().func_186855_b("arcaneLockOwner")) {
                if (world.func_152378_a(Objects.requireNonNull(tileentity.getTileData().func_186857_a("arcaneLockOwner"))) == player && ChantWorker.useMana((Entity)player, 10.0)) {
                    NBTExtras.removeUniqueId((NBTTagCompound)tileentity.getTileData(), (String)"arcaneLockOwner");
                    world.markAndNotifyBlock(pos, null, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                    return true;
                }
            } else if (ChantWorker.useMana((Entity)player, 10.0)) {
                tileentity.getTileData().func_186854_a("arcaneLockOwner", player.func_110124_au());
                world.markAndNotifyBlock(pos, null, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static BlockPos findAir(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.values()) {
            if (!(world.func_180495_p(pos.func_177972_a(face)).func_177230_c() instanceof BlockAir)) continue;
            return pos.func_177972_a(face);
        }
        return null;
    }

    public static boolean canBypassLocks(EntityPlayer player) {
        if (!player.func_184812_l_()) {
            return false;
        }
        if (Wizardry.settings.creativeBypassesArcaneLock) {
            return true;
        }
        MinecraftServer server = player.field_70170_p.func_73046_m();
        return server != null && EntityUtils.isPlayerOp((EntityPlayer)player, (MinecraftServer)server);
    }
}

