/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.data;

import java.util.Arrays;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.GameRegistry;

@GameRegistry.ObjectHolder(value="wizardry_tales")
@Config(modid="wizardry_tales", type=Config.Type.INSTANCE, name="WizardryTales-2.0+")
public class Tales {
    @Config.Comment(value={"Mana Pool System, which makes player really become master wizard slowly!"})
    @Config.Name(value="Player Mana System")
    public static ManaPoolSystem mp = new ManaPoolSystem();
    @Config.Comment(value={"Mana Pool System, which makes player not looks like master wizard from beginning!"})
    @Config.Name(value="Visual Effects")
    public static VisualEffects effects = new VisualEffects();
    @Config.Comment(value={"Change their different options!"})
    @Config.Name(value="Entities of Tales")
    public static Entities entities = new Entities();
    @Config.Comment(value={"Some things for balance"})
    @Config.Name(value="Chanting")
    public static Chanting chanting = new Chanting();
    @Config.Comment(value={"Tweaks and Additions Tales does"})
    @Config.Name(value="Additions")
    public static Additions addon = new Additions();
    @Config.Comment(value={"Change their frequency, or allowed dimensions"})
    @Config.Name(value="Structures of Tales")
    public static Structures struct = new Structures();

    public static ResourceLocation[] toResourceLocations(String[] strings) {
        return (ResourceLocation[])Arrays.stream(strings).map(s -> new ResourceLocation(s.toLowerCase(Locale.ROOT).trim())).toArray(ResourceLocation[]::new);
    }

    public static ResourceLocation toResourceLocation(String string) {
        return new ResourceLocation(string.toLowerCase(Locale.ROOT).trim());
    }

    public static class Structures {
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of Altar structure, so bigger - means lower chance"})
        @Config.Name(value="1: Altar Rarity")
        public int altar = 800;
        @Config.Comment(value={"Allowed to spawn Altar dimensions"})
        @Config.Name(value="1: Altar Dimensions")
        public int[] altar_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of Altar structure, so bigger - means lower chance"})
        @Config.Name(value="1: Teleportation Anchor Rarity")
        public int anchor = 1000;
        @Config.Comment(value={"Allowed to spawn Anchor dimensions"})
        @Config.Name(value="1: Teleportation Anchor Dimensions")
        public int[] anchor_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Teleportation Anchor(Not Peaceful) Rarity")
        public int anchor_angry = 900;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Teleportation Anchor(Not Peaceful) Dimensions")
        public int[] anchor_angry_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Young Wizards Houses Rarity")
        public int novice_house = 700;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Young Wizards Houses Dimensions")
        public int[] novice_house_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Flying Libraries Rarity")
        public int flying_lib = 1200;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Flying Libraries Dimensions")
        public int[] flying_lib_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Flying Big Libraries Rarity")
        public int flying_lib_big = 1500;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Flying Big Libraries Dimensions")
        public int[] flying_lib_big_dims = new int[]{0};
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"The chance for wizard towers to have an evil female wizard and chest inside."})
        @Config.Name(value="1: Old Female Wizards Evil chance")
        public double evilLadyWizardChance = 0.2;
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Old Female Wizards Towers Rarity")
        public int lady_wizard = 900;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Old Female Wizards Dimensions")
        public int[] lady_wizard_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Libraries Rarity")
        public int lib = 1500;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Libraries Dimensions")
        public int[] lib_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Underground House Rarity")
        public int underground_house = 900;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Underground House Dimensions")
        public int[] underground_house_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of Altar structure, so bigger - means lower chance"})
        @Config.Name(value="1: Aterna's Shrine")
        public int shrine_healing = 1700;
        @Config.Comment(value={"Allowed to spawn Altar dimensions"})
        @Config.Name(value="1: Aterna's Shrine Dimensions")
        public int[] shrine_healing_dims = new int[]{0};
        @Config.RangeInt(min=20, max=5000)
        @Config.Comment(value={"Spawn chance of this structure, so bigger - means lower chance"})
        @Config.Name(value="1: Spell-Witch Hut Rarity")
        public int spell_witch_hut = 700;
        @Config.Comment(value={"Allowed to spawn dimensions"})
        @Config.Name(value="1: Spell-Witch Hut Dimensions")
        public int[] spell_witch_hut_dims = new int[]{0};
        @Config.Comment(value={"Loot injection entries"})
        @Config.Name(value="0: Where Tales loot be found in?")
        public String[] tales_loot_entries = new String[]{"minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/stronghold_corridor", "minecraft:chests/stronghold_crossing", "minecraft:chests/stronghold_library", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion", "minecraft:chests/end_city_treasure"};
    }

    public static class Additions {
        @Config.Comment(value={"Testers and those who helped Tales have a special circle above their head"})
        @Config.Name(value="Testers Perk")
        public boolean testers_perk = true;
        @Config.Comment(value={"If enabled - Tales has spells, if disabled - Tales has no spells. Simple!"})
        @Config.Name(value="Spells")
        public boolean spells = true;
        @Config.Comment(value={"If enabled - You need to learn how to cast spells first to use them properly!"})
        @Config.Name(value="Spells Learning")
        public boolean learning = false;
        @Config.Comment(value={"If enabled - After death monsters will drop crystals basing of their max health."})
        @Config.Name(value="Monsters Drop Crystals?")
        public boolean monsters_drop_crystals = false;
    }

    public static class Chanting {
        @Config.Comment(value={"If it is true - then Chanting can cause throwing the error"})
        @Config.Name(value="Debug Mode")
        public boolean debug = false;
        @Config.Comment(value={"You can use 'apply' action to apply to yourself or others potion effects"})
        @Config.Name(value="Apply effect Blacklist")
        public String[] applyBlacklist = new String[]{"minecraft:instant_damage", "minecraft:instant_health", "minecraft:wither", "wizardry_tales:magic_exhaust"};
        @Config.Comment(value={"You can say 'summon' + minion id, to summon the minion you want"})
        @Config.Name(value="Action: Minion Blacklist")
        public String[] minionBlacklist = new String[]{"example_modid:example_entry", "ebwizardry:example"};
        @Config.Comment(value={"You can say 'summon' + construct id, to summon the construct you want"})
        @Config.Name(value="Action: Construct Blacklist")
        public String[] constructBlacklist = new String[]{"ebwizardry:zombie_spawner"};
        @Config.Comment(value={"You can say 'replicate' + spell id, to replicate spell you discovered and have learned."})
        @Config.Name(value="Action: Replication Blacklist")
        public String[] replicationBlacklist = new String[]{"modid:example_spell"};
    }

    public static class Entities {
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        @Config.SlidingOption
        @Config.Comment(value={"Higher numbers mean more them will spawn. 5 is equivalent to witches, 100 is equivalent to zombies, skeletons and creepers. Set to 0 to disable spawning entirely."})
        @Config.Name(value="Mushroom: Spawnrate")
        public int mushroomSpawnRate = 50;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Biomes where they can spawn"})
        @Config.Name(value="Mushroom: Allowed to spawn Biomes")
        public String[] mushroomBiomeWhitelist = new String[]{"roofed_forest", "mutated_roofed_forest", "mushroom_island", "mushroom_island_shore"};
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        @Config.SlidingOption
        @Config.Comment(value={"Higher numbers mean more them will spawn. 5 is equivalent to witches, 100 is equivalent to zombies, skeletons and creepers. Set to 0 to disable spawning entirely."})
        @Config.Name(value="Big Mushroom: Spawnrate")
        public int big_mushroomSpawnRate = 5;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Biomes where they can spawn"})
        @Config.Name(value="Big Mushroom: Allowed to spawn Biomes")
        public String[] big_mushroomBiomeWhitelist = new String[]{"roofed_forest", "mutated_roofed_forest", "mushroom_island", "mushroom_island_shore"};
        @Config.RequiresMcRestart
        @Config.RangeInt(min=0, max=100)
        @Config.SlidingOption
        @Config.Comment(value={"Higher numbers mean more them will spawn. 5 is equivalent to witches, 100 is equivalent to zombies, skeletons and creepers. Set to 0 to disable spawning entirely."})
        @Config.Name(value="Envenomed Blade: Spawnrate")
        public int envenomed_bladeSpawnRate = 30;
        @Config.RequiresMcRestart
        @Config.Comment(value={"Biomes where they can spawn"})
        @Config.Name(value="Envenomed Blade: Allowed to spawn Biomes")
        public String[] envenomed_bladeBiomeWhitelist = new String[]{"roofed_forest", "mutated_roofed_forest", "swamp", "swampland", "mutated_swampland"};
    }

    public static class VisualEffects {
        @Config.RequiresMcRestart
        @Config.Comment(value={"Will Visual Effects appear at all?"})
        @Config.Name(value="0: Is Enabled?")
        public boolean enabled = true;
        @Config.Comment(value={"Does circles appear on Summon of someone?"})
        @Config.Name(value="1: On Summon")
        public boolean onSummon = true;
        @Config.Comment(value={"Magical Circles that appear on continuous or charge-up-required spells"})
        @Config.Name(value="1: Circles appearing on Long spells")
        public boolean long_spelled = true;
        @Config.Comment(value={"Magical Circles that appear on continuous or charge-up-required spells"})
        @Config.Name(value="1: Vertical Circles appearing on Long spells")
        public boolean vertical_long_spelled = true;
        @Config.Comment(value={"When you use continuous spell - you'll see circle rotating"})
        @Config.Name(value="1: Render Continuous Circles")
        public boolean rendered_circles = true;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Distance from the player to point where circle appears"})
        @Config.Name(value="Vertical Circles Distance")
        public double look_distance = 2.5;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Offset by Y from player foot to where circle appears"})
        @Config.Name(value="Vertical Circles Y Offset")
        public double look_y_offset = 1.4;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Offset by Y from player foot to where circle appears"})
        @Config.Name(value="Circles Y Offset")
        public double y_offset = 0.0;
        @Config.RangeDouble(min=0.1, max=20.0)
        @Config.Comment(value={"Size of Circles created. Not related to Vertical ones"})
        @Config.Name(value="Circles Size")
        public double circle_size = 2.0;
        @Config.RangeDouble(min=0.1, max=20.0)
        @Config.Comment(value={"Size of Vertical Circles created. Not related to not-Vertical ones"})
        @Config.Name(value="Vertical Circles Size")
        public double vertical_circle_size = 1.0;
    }

    public static class ManaPoolSystem {
        @Config.Comment(value={"If it is true - then mana pool exist"})
        @Config.Name(value="0: Active")
        public boolean manaPool = true;
        @Config.Comment(value={"If it is true - then we see mana pool as bar"})
        @Config.Name(value="0: Bar")
        public boolean manaPoolBar = true;
        @Config.Comment(value={"If it is true - then mana from wands when you cast spell - will not be used"})
        @Config.Name(value="Is items mana not used anymore?")
        public boolean noMoreManaUse = true;
        @Config.Comment(value={"If it is true - then casting cost bases on spell cost, if it's false - then it bases of spell tier"})
        @Config.Name(value="Is casting Cost based on Spell Cost?")
        public boolean isCastingCostBased = true;
        @Config.Comment(value={"If it is true - then if your mana is near 0, you'll get debuffs."})
        @Config.Name(value="Are you get debuff when mana is low? ")
        public boolean lowOnMana = true;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Allows to change cost of using spells, by multiplying final cost on this value (cost * this)", "Cost of spell is calculated: this * (Spell-Tier * Spell-Tier)", "So setting it to 0.0 will make spellcasting not use Mana Pool at all"})
        @Config.Name(value="1: Spell Cost Multiplier")
        public double spell_multiplier = 1.0;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Allows to change cost of using Chanting, by multiplying cost of each chant part on this value (cost * this)"})
        @Config.Name(value="1: Chanting Cost Multiplier")
        public double chant_multiplier = 0.5;
        @Config.RangeDouble(min=1.0)
        @Config.Comment(value={"Max Mana in your pool available from the beginning. It'll grow as you cast spells up to Max. "})
        @Config.Name(value="1: Mana Pool Initial")
        public double initial = 10.0;
        @Config.RangeDouble(min=1.0)
        @Config.Comment(value={"Max Mana in your pool available at all. Can't be higher then this [value]"})
        @Config.Name(value="1: Mana Pool Max")
        public double max = 2500.0;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Each successful cast increases Mana Pool, this way you can define how much Max mana added. Can't be higher then [Mana Pool Max]", "After successful cast, your progress is", "[This] * ([Progression Multiplier] * (spell-cost-for-pool / player-current-max-mana))"})
        @Config.Name(value="2: Mana Pool Progression")
        public double progression = 0.02;
        @Config.RangeDouble(min=1.0)
        @Config.Comment(value={"Each successful cast increases Mana Pool, this way you can define how much Max mana added. Can't be higher then [Mana Pool Max]", "After successful cast, your progress is", "[This] * ([Progression Multiplier] * (spell-cost-for-pool / player-current-max-mana))"})
        @Config.Name(value="2: Mana Pool Progression Multiplier")
        public double progression_multiplier = 4.0;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Each [Mana Pool Regeneration Frequency] seconds regenerates this [value] to your mana pool"})
        @Config.Name(value="2: Mana Pool Regeneration")
        public double regeneration = 0.1;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"The maximum plus to your mana pool regen you can get. It scales of how close you are to Mana Pool Max"})
        @Config.Name(value="2: Mana Pool Regeneration Bonus")
        public double bonus_regen = 1.0;
        @Config.RangeDouble(min=0.1)
        @Config.Comment(value={"Frequency of Mana Regeneration in seconds (0.5 = 10 ticks)"})
        @Config.Name(value="2: Mana Pool Regeneration Seconds Frequency")
        public double seconds_frequency = 0.2;
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Spell Cost * This multiplier for Casting ring casting"})
        @Config.Name(value="3: Casting Ring Cost Multiplier")
        public double casting_ring_cost = 1.0;
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Not to allow just spam too much with cast. 20 = 1 second"})
        @Config.Name(value="3: Casting Ring Cooldown")
        public int casting_ring_cooldown = 20;
        @Config.RangeInt(min=0)
        @Config.Comment(value={"How much it gives mana upon usage?"})
        @Config.Name(value="3: Mana Flask: Small")
        public int mana_flask_small = 75;
        @Config.RangeInt(min=0)
        @Config.Comment(value={"How much it gives mana upon usage?"})
        @Config.Name(value="3: Mana Flask: Medium")
        public int mana_flask_medium = 350;
        @Config.RangeInt(min=0)
        @Config.Comment(value={"How much it gives mana upon usage?"})
        @Config.Name(value="3: Mana Flask: Large")
        public int mana_flask_large = 1400;
    }
}

