/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.data.cap;

import astramusfate.wizardry_tales.WizardryTales;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.SoulProvider;
import astramusfate.wizardry_tales.spells.TalesSpells;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.spell.Spell;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="wizardry_tales")
public class CapabilityHandler {
    public static final ResourceLocation SOUL = new ResourceLocation("wizardry_tales", "soul");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(SOUL, (ICapabilityProvider)new SoulProvider());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        WizardData data;
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer current = event.getEntityPlayer();
        ISoul soul = (ISoul)current.getCapability(SoulProvider.SOUL_CAP, null);
        if (soul == null) {
            WizardryTales.log.warn("[Wizardry Tales]: Can't find new Soul!");
            return;
        }
        EntityPlayer old = event.getOriginal();
        ISoul oldSoul = (ISoul)old.getCapability(SoulProvider.SOUL_CAP, null);
        if (oldSoul == null) {
            WizardryTales.log.warn("[Wizardry Tales]: Can't find old Soul!");
            return;
        }
        int MP = (int)Math.ceil(oldSoul.getMP());
        double maxMP = oldSoul.getMaxMP();
        int cooldown = oldSoul.getCooldown();
        int mode = oldSoul.getMode();
        String race = oldSoul.getRace();
        Map<Spell, Integer> learnedSpells = oldSoul.getLearnedSpells();
        soul.setMaxMP(current, maxMP);
        soul.setMP(current, MP);
        soul.setMP(old, MP);
        soul.setCooldown(current, cooldown);
        soul.setMode(current, mode);
        soul.setRace(current, race);
        if (Tales.addon.learning) {
            soul.setLearnedSpells(current, learnedSpells);
        }
        if ((data = WizardData.get((EntityPlayer)current)) != null) {
            data.discoverSpell(TalesSpells.chanting);
        }
    }
}

