/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.data.cap;

import astramusfate.wizardry_tales.data.PacketMagic;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.SoulProvider;
import astramusfate.wizardry_tales.data.packets.PacketCastingRingCooldown;
import astramusfate.wizardry_tales.data.packets.PacketLearnSpell;
import astramusfate.wizardry_tales.data.packets.PacketRace;
import astramusfate.wizardry_tales.data.packets.PacketSoulMana;
import astramusfate.wizardry_tales.data.packets.PacketSyncLearning;
import astramusfate.wizardry_tales.data.packets.PacketSyncMode;
import electroblob.wizardry.spell.None;
import electroblob.wizardry.spell.Spell;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Soul
implements ISoul {
    private double MP = 0.0;
    private double maxMP;
    private int cooldown;
    private int mode;
    private String race;
    private Map<Spell, Integer> learnedSpells;

    public Soul() {
        this.maxMP = Tales.mp.initial;
        this.cooldown = 0;
        this.mode = 0;
        this.race = "human";
        this.learnedSpells = new HashMap<Spell, Integer>();
    }

    @Override
    public void addMana(double add) {
        this.MP = Math.min(Math.max(this.MP + add, 0.0), this.maxMP);
    }

    @Override
    public void addMana(EntityPlayer player, double add) {
        this.MP = Math.min(Math.max(this.MP + add, 0.0), this.maxMP);
        this.syncMana(player, this.MP);
    }

    @Override
    public void setMP(double set) {
        this.MP = Math.min(Math.max(set, 0.0), this.maxMP);
    }

    @Override
    public void setMP(EntityPlayer player, double set) {
        this.MP = Math.min(Math.max(set, 0.0), this.maxMP);
        this.syncMana(player, this.MP);
    }

    @Override
    public void setMaxMP(double set) {
        this.maxMP = Math.min(set, Tales.mp.max);
    }

    @Override
    public void setMaxMP(EntityPlayer player, double set) {
        this.maxMP = Math.min(set, Tales.mp.max);
        this.syncMaxMana(player, this.maxMP);
    }

    @Override
    public void addMaxMana(double add) {
        this.maxMP = Math.min(Math.max(this.maxMP + add, 0.0), Tales.mp.max);
    }

    @Override
    public void addMaxMana(EntityPlayer player, double add) {
        this.maxMP = Math.min(Math.max(this.maxMP + add, 0.0), Tales.mp.max);
        this.syncMaxMana(player, this.maxMP);
    }

    @Override
    public double getMP() {
        return this.MP;
    }

    @Override
    public double getMaxMP() {
        return this.maxMP;
    }

    @Override
    public String getRace() {
        return this.race;
    }

    @Override
    public void setRace(EntityPlayer player, String race) {
        this.race = race;
        this.syncRace(player, race);
    }

    @Override
    public void setRace(String race) {
        this.race = race;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(EntityPlayer player, int mode) {
        this.mode = mode;
        this.syncMode(player, mode);
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setCooldown(EntityPlayer player, int set) {
        this.cooldown = set;
        this.syncCooldown(player, this.cooldown);
    }

    @Override
    public void setCooldown(int set) {
        this.cooldown = set;
    }

    @Override
    public void decreaseCooldown(@Nullable EntityPlayer player, int decrease) {
        this.cooldown -= decrease;
        this.syncCooldown(player, this.cooldown);
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void sync(EntityPlayer player) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            PacketMagic.net.sendTo((IMessage)new PacketSoulMana(soul.getMP(), soul.getMaxMP()), (EntityPlayerMP)player);
        }
    }

    @Override
    public void syncMana(EntityPlayer player, double mana) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            PacketMagic.net.sendTo((IMessage)new PacketSoulMana(mana, soul.getMaxMP()), (EntityPlayerMP)player);
        }
    }

    @Override
    public void syncMaxMana(EntityPlayer player, double maxMana) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            PacketMagic.net.sendTo((IMessage)new PacketSoulMana(soul.getMP(), maxMana), (EntityPlayerMP)player);
        }
    }

    @Override
    public void syncCooldown(EntityPlayer player, int cooldown) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            PacketMagic.net.sendTo((IMessage)new PacketCastingRingCooldown(cooldown), (EntityPlayerMP)player);
        }
    }

    @Override
    public void syncMode(EntityPlayer player, int mode) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            PacketMagic.net.sendTo((IMessage)new PacketSyncMode(mode), (EntityPlayerMP)player);
        }
    }

    @Override
    public void syncRace(EntityPlayer player, String race) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null) {
            PacketMagic.net.sendTo((IMessage)new PacketRace(race), (EntityPlayerMP)player);
        }
    }

    @Override
    public void syncLearnedSpells(EntityPlayer player) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null && Tales.addon.learning) {
            PacketMagic.net.sendTo((IMessage)new PacketSyncLearning(soul.getLearnedSpells()), (EntityPlayerMP)player);
        }
    }

    @Override
    public void syncLearnSpell(EntityPlayer player, Spell spell) {
        ISoul soul;
        if (player instanceof EntityPlayerMP && (soul = (ISoul)player.getCapability(SoulProvider.SOUL_CAP, null)) != null && Tales.addon.learning) {
            PacketMagic.net.sendTo((IMessage)new PacketLearnSpell(spell), (EntityPlayerMP)player);
        }
    }

    @Override
    public void setLearnedSpells(EntityPlayer player, Map<Spell, Integer> spellsLearned) {
        this.learnedSpells = spellsLearned;
        this.syncLearnedSpells(player);
    }

    @Override
    public void learnSpell(EntityPlayer player, Spell spell) {
        if (this.learnedSpells == null) {
            this.learnedSpells = new HashMap<Spell, Integer>();
        }
        if (spell instanceof None) {
            return;
        }
        if (this.learnedSpells.containsKey(spell)) {
            this.learnedSpells.replace(spell, this.learnedSpells.get(spell) + 1);
        } else {
            this.learnedSpells.put(spell, 1);
        }
        this.syncLearnSpell(player, spell);
    }

    @Override
    public int getLearned(Spell spell) {
        if (!Tales.addon.learning) {
            return 11;
        }
        if (this.learnedSpells == null) {
            this.learnedSpells = new HashMap<Spell, Integer>();
        }
        if (!this.learnedSpells.containsKey(spell)) {
            this.learnedSpells.put(spell, 1);
        }
        return this.learnedSpells.get(spell);
    }

    @Override
    public Map<Spell, Integer> getLearnedSpells() {
        return this.learnedSpells;
    }
}

