/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.data.chanting;

import astramusfate.wizardry_tales.data.ChantWorker;
import astramusfate.wizardry_tales.data.Lexicon;
import astramusfate.wizardry_tales.data.chanting.SpellParam;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.util.SpellModifiers;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SpellParams
implements Lexicon {
    public SpellParam potency = new SpellParam("power potency damage", 1.0f){

        @Override
        public boolean canApply(Number number) {
            return number.floatValue() >= 1.0f;
        }
    };
    public SpellParam duration = new SpellParam("duration", 5.0f);
    public SpellParam range = new SpellParam("range", 12.0f){

        @Override
        public boolean canApply(Number number) {
            return number.intValue() > 0;
        }
    };
    public SpellParam lifetime = new SpellParam("lifetime", 5.0f){

        @Override
        public boolean canApply(Number number) {
            return number.intValue() != 0;
        }
    };
    public SpellParam health = new SpellParam("health", 1.0f){

        @Override
        public boolean canApply(Number number) {
            return number.intValue() > 0;
        }
    };
    public SpellParam size = new SpellParam("size radius", 2.0f){

        @Override
        public boolean canApply(Number number) {
            return number.intValue() > 0;
        }
    };
    public static final String[] shapes = new String[]{"entity entities", "area", "sigil", "minion", "projectile", "construct", "inscribe scribe", "adjust change", "block blocks", "me", "collector", "array"};
    public SpellParam shape = new SpellParam("shape", "me"){

        @Override
        public boolean canApply(String value) {
            for (String shape : shapes) {
                if (!ChantWorker.findInSmart(value, shape)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canApply(Number number) {
            return false;
        }
    };
    public SpellParam[] autoCalc = new SpellParam[]{this.potency, this.duration, this.size, this.range, this.lifetime, this.health, this.shape};
    public Vec3d pos = null;
    public Vec3d change = new Vec3d(0.0, 0.0, 0.0);
    public boolean isRay = false;
    public boolean isBuff = false;
    public boolean stopCast = false;
    public Element element = Element.MAGIC;
    public World world;
    public List<String> set;
    public HashMap<String, String> keys = new HashMap();
    public BlockPos savedPos = null;
    public boolean canAlly = false;
    public boolean hasOwner = true;
    public boolean hasEffects = true;
    public int castingTargeting = 0;
    public RayTraceResult ray = null;
    public Entity focal;
    public Entity target;
    public boolean isServer;
    public String original;
    public SpellModifiers spellModifiers;
    public Predicate<Entity> filter = Objects::nonNull;

    public void calcParam(String word, Object value) {
        for (SpellParam param : this.autoCalc) {
            if (!ChantWorker.findInSmart(word, param.name())) continue;
            if (value instanceof Number && param.canApply((Number)value)) {
                param.setNumber((Number)value);
            }
            if (!(value instanceof String) || !param.canApply((String)value)) break;
            param.setValue((String)value);
            break;
        }
    }
}

