/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.data.packets;

import astramusfate.wizardry_tales.api.Thief;
import astramusfate.wizardry_tales.data.ChantWorker;
import astramusfate.wizardry_tales.data.Tales;
import astramusfate.wizardry_tales.data.cap.ISoul;
import astramusfate.wizardry_tales.data.cap.Mana;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCastingRing
implements IMessage {
    public int casterID;
    public int spellID;
    public SpellModifiers modifiers;

    public PacketCastingRing() {
    }

    public PacketCastingRing(int casterID, Spell spell, SpellModifiers modifiers) {
        this.casterID = casterID;
        this.spellID = spell.networkID();
        this.modifiers = modifiers;
    }

    public void fromBytes(ByteBuf buf) {
        this.casterID = buf.readInt();
        this.spellID = buf.readInt();
        this.modifiers = new SpellModifiers();
        this.modifiers.read(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.casterID);
        buf.writeInt(this.spellID);
        this.modifiers.write(buf);
    }

    public static class PacketHandler
    implements IMessageHandler<PacketCastingRing, IMessage> {
        public IMessage onMessage(PacketCastingRing message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    World world = player.field_70170_p;
                    if (!(world.func_73045_a(message.casterID) instanceof EntityPlayer)) {
                        return;
                    }
                    EntityPlayer caster = (EntityPlayer)world.func_73045_a(message.casterID);
                    if (caster == null) {
                        return;
                    }
                    ItemStack wand = Thief.getWandInUse((EntityPlayer)player);
                    if (wand == null) {
                        return;
                    }
                    ISoul soul = Mana.getSoul((EntityPlayer)player);
                    if (soul == null) {
                        return;
                    }
                    Spell spell = Spell.byNetworkID((int)message.spellID);
                    if (WizardData.get((EntityPlayer)player) != null && !WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
                        return;
                    }
                    SpellModifiers modifiers = message.modifiers;
                    int duration = 100;
                    int seconds = duration / 20;
                    int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
                    if (spell.isContinuous) {
                        cost *= seconds;
                    }
                    cost = (int)((double)cost * Tales.mp.casting_ring_cost);
                    if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers))) {
                        return;
                    }
                    if (spell.isContinuous) {
                        WizardData data = WizardData.get((EntityPlayer)caster);
                        if (data != null) {
                            if (data.isCasting()) {
                                data.stopCastingContinuousSpell();
                            } else {
                                if (!ChantWorker.useMana((Entity)player, cost) || soul.getCooldown() > 0) {
                                    return;
                                }
                                data.startCastingContinuousSpell(spell, modifiers, duration);
                                soul.setCooldown((EntityPlayer)player, Tales.mp.casting_ring_cooldown);
                            }
                        }
                    } else {
                        if (!ChantWorker.useMana((Entity)player, cost) || soul.getCooldown() > 0) {
                            return;
                        }
                        soul.setCooldown((EntityPlayer)player, Tales.mp.casting_ring_cooldown);
                        if (spell.cast(caster.field_70170_p, caster, EnumHand.MAIN_HAND, 0, modifiers)) {
                            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers));
                            if (spell.requiresPacket()) {
                                PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), null, spell, modifiers);
                                WizardryPacketHandler.net.sendToDimension((IMessage)msg, caster.field_70170_p.field_73011_w.getDimension());
                            }
                        }
                    }
                });
            }
            return null;
        }
    }
}

