/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.data.packets;

import astramusfate.wizardry_tales.WizardryTales;
import com.google.common.collect.Lists;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncLearning
implements IMessage {
    public Map<Spell, Integer> spells;

    public PacketSyncLearning() {
    }

    public PacketSyncLearning(Map<Spell, Integer> spells) {
        this.spells = spells;
    }

    public void toBytes(ByteBuf buf) {
        if (this.spells == null) {
            this.spells = new HashMap<Spell, Integer>();
        }
        this.spells.put(Spells.magic_missile, 11);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagIntArray array = new NBTTagIntArray((List)Lists.newArrayList(this.spells.values()));
        tag.func_74782_a("data", (NBTBase)array);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        for (Spell spell : this.spells.keySet()) {
            buf.writeInt(spell.networkID());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.spells = new HashMap<Spell, Integer>();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag != null) {
            NBTTagIntArray array = (NBTTagIntArray)tag.func_74781_a("data");
            for (int i = 0; i <= array.func_150302_c().length; ++i) {
                this.spells.put(Spell.byNetworkID((int)buf.readInt()), array.func_150302_c()[i]);
            }
        }
    }

    public static class PacketHandler
    implements IMessageHandler<PacketSyncLearning, IMessage> {
        public IMessage onMessage(PacketSyncLearning message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                Minecraft.func_71410_x().func_152344_a(() -> WizardryTales.proxy.handleSpellsLearning(message));
            }
            return null;
        }
    }
}

