/*
 * Decompiled with CFR 0.152.
 */
package astramusfate.wizardry_tales.entity.ai;

import astramusfate.wizardry_tales.api.classes.IEntitySit;
import com.google.common.collect.Streams;
import electroblob.wizardry.entity.living.ISummonedCreature;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAIFollowCaster
extends EntityAIBase {
    private final ISummonedCreature summon;
    EntityLiving creature;
    private EntityLivingBase owner;
    World world;
    private final double followSpeed;
    private final PathNavigate petPathfinder;
    private int timeToRecalcPath;
    float maxDist;
    float minDist;
    private float oldWaterCost;

    public EntityAIFollowCaster(ISummonedCreature summon, EntityLiving creature, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.summon = summon;
        this.creature = creature;
        this.world = creature.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = creature.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_75248_a(3);
        if (!(creature.func_70661_as() instanceof PathNavigateGround) && !(creature.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.summon.getCaster();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).func_175149_v()) {
            return false;
        }
        if (this.creature.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.creature.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && (!(this.creature instanceof IEntitySit) || !((IEntitySit)this.creature).isSitting());
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.creature.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.petPathfinder.func_75499_g();
        this.creature.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.creature.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.creature.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.petPathfinder.func_75497_a((Entity)this.owner, this.followSpeed) && !this.creature.func_110167_bD() && !this.creature.func_184218_aH() && this.creature.func_70068_e((Entity)this.owner) >= 144.0) {
                int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                        this.creature.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), this.creature.field_70177_z, this.creature.field_70125_A);
                        this.petPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y - 1.0, z);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.creature) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }

    protected boolean isTeleportFriendlyBlock(int x, int z, int y, int x_offset, int z_offset) {
        BlockPos blockpos = new BlockPos(x + x_offset, y - 1, z + z_offset);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.creature) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }

    public static Vec3d findSafeTeleportPoint(Entity entity, Vec3d destination) {
        World world = entity.field_70170_p;
        AxisAlignedBB box = entity.func_174813_aQ();
        box = box.func_191194_a(destination.func_178786_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        Iterable cuboid = BlockPos.func_191532_a((int)MathHelper.func_76128_c((double)box.field_72340_a), (int)MathHelper.func_76128_c((double)box.field_72338_b), (int)MathHelper.func_76128_c((double)box.field_72339_c), (int)MathHelper.func_76128_c((double)box.field_72336_d), (int)MathHelper.func_76128_c((double)box.field_72337_e), (int)MathHelper.func_76128_c((double)box.field_72334_f));
        if (Streams.stream((Iterable)cuboid).noneMatch(b -> world.func_184143_b(new AxisAlignedBB(b)))) {
            return destination;
        }
        return null;
    }
}

